/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class BoostersGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final T team;
    private final IridiumTeams<T, U> iridiumTeams;
    private final Map<Integer, String> boosters = new HashMap<Integer, String>();

    public BoostersGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().boostersGUI.background, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI noItemGUI = this.iridiumTeams.getInventories().boostersGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)noItemGUI.size, (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (Map.Entry<String, Enhancement<?>> enhancementEntry : this.iridiumTeams.getEnhancementList().entrySet()) {
            String nextLevel;
            if (enhancementEntry.getValue().type != EnhancementType.BOOSTER) continue;
            this.boosters.put(enhancementEntry.getValue().item.slot, enhancementEntry.getKey());
            TeamEnhancement teamEnhancement = this.iridiumTeams.getTeamManager().getTeamEnhancement(this.team, enhancementEntry.getKey());
            EnhancementData currentData = (EnhancementData)enhancementEntry.getValue().levels.get(teamEnhancement.getLevel());
            EnhancementData nextData = (EnhancementData)enhancementEntry.getValue().levels.get(teamEnhancement.getLevel() + 1);
            int seconds = Math.max((int)(teamEnhancement.getRemainingTime() % 60L), 0);
            int minutes = Math.max((int)(teamEnhancement.getRemainingTime() % 3600L / 60L), 0);
            int hours = Math.max((int)(teamEnhancement.getRemainingTime() / 3600L), 0);
            int currentLevel = teamEnhancement.isActive(enhancementEntry.getValue().type) ? teamEnhancement.getLevel() : 0;
            String string = nextLevel = nextData == null ? this.iridiumTeams.getMessages().nullPlaceholder : String.valueOf(currentLevel + 1);
            String cost = nextData == null ? (currentData == null ? this.iridiumTeams.getMessages().nullPlaceholder : String.valueOf(currentData.money)) : String.valueOf(nextData.money);
            String minLevel = nextData == null ? this.iridiumTeams.getMessages().nullPlaceholder : String.valueOf(nextData.minLevel);
            ArrayList<Placeholder> placeholders = currentData == null ? new ArrayList<Placeholder>() : new ArrayList<Placeholder>(currentData.getPlaceholders());
            placeholders.addAll(Arrays.asList(new Placeholder("timeremaining_hours", String.valueOf(hours)), new Placeholder("timeremaining_minutes", String.valueOf(minutes)), new Placeholder("timeremaining_seconds", String.valueOf(seconds)), new Placeholder("current_level", String.valueOf(currentLevel)), new Placeholder("minLevel", minLevel), new Placeholder("next_level", nextLevel), new Placeholder("cost", cost), new Placeholder("vault_cost", cost)));
            if (nextData != null) {
                for (Map.Entry<String, Double> bankItem : nextData.bankCosts.entrySet()) {
                    placeholders.add(new Placeholder(bankItem.getKey() + "_cost", this.formatPrice(bankItem.getValue())));
                }
            }
            inventory.setItem(enhancementEntry.getValue().item.slot.intValue(), ItemStackUtils.makeItem(enhancementEntry.getValue().item, placeholders));
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        if (!this.boosters.containsKey(event.getSlot())) {
            return;
        }
        String booster = this.boosters.get(event.getSlot());
        this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().boostersCommand, new String[]{"buy", booster});
    }

    public String formatPrice(double value) {
        if (this.iridiumTeams.getShop().abbreviatePrices) {
            return this.iridiumTeams.getConfiguration().numberFormatter.format(value);
        }
        return String.valueOf(value);
    }
}

