/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.GUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.InventoryUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.InventoryConfig;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class InventoryConfigGUI
implements GUI {
    private final InventoryConfig inventoryConfig;

    public InventoryConfigGUI(InventoryConfig inventoryConfig) {
        this.inventoryConfig = inventoryConfig;
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.inventoryConfig.size, (String)StringUtils.color(this.inventoryConfig.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        InventoryUtils.fillInventory(inventory, this.inventoryConfig.background);
        this.inventoryConfig.items.values().forEach(item -> {
            if (item.slot >= 0) {
                inventory.setItem(item.slot.intValue(), ItemStackUtils.makeItem(item));
            }
        });
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        for (String command : this.inventoryConfig.items.keySet()) {
            if (this.inventoryConfig.items.get((Object)command).slot.intValue() != event.getSlot()) continue;
            Bukkit.getServer().dispatchCommand((CommandSender)event.getWhoClicked(), command);
        }
    }
}

