/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.PagedGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.SingleItemGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamInvite;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InvitesGUI<T extends Team, U extends IridiumUser<T>>
extends PagedGUI<TeamInvite> {
    private final T team;
    private final IridiumTeams<T, U> iridiumTeams;

    public InvitesGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(1, iridiumTeams.getInventories().invitesGUI.size, iridiumTeams.getInventories().invitesGUI.background, iridiumTeams.getInventories().previousPage, iridiumTeams.getInventories().nextPage, player, iridiumTeams.getInventories().backButton);
        this.team = team;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        SingleItemGUI noItemGUI = this.iridiumTeams.getInventories().invitesGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public Collection<TeamInvite> getPageObjects() {
        return this.iridiumTeams.getTeamManager().getTeamInvites(this.team);
    }

    @Override
    public ItemStack getItemStack(TeamInvite teamInvite) {
        Optional<U> user = this.iridiumTeams.getUserManager().getUserByUUID(teamInvite.getUser());
        ArrayList<Placeholder> placeholderList = new ArrayList<Placeholder>(this.iridiumTeams.getUserPlaceholderBuilder().getPlaceholders(user));
        placeholderList.add(new Placeholder("invite_time", teamInvite.getTime().format(DateTimeFormatter.ofPattern(this.iridiumTeams.getConfiguration().dateTimeFormat))));
        return ItemStackUtils.makeItem(this.iridiumTeams.getInventories().invitesGUI.item, placeholderList);
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        TeamInvite teamInvite = (TeamInvite)this.getItem(event.getSlot());
        if (teamInvite == null) {
            return;
        }
        String username = this.iridiumTeams.getUserManager().getUserByUUID(teamInvite.getUser()).map(IridiumUser::getName).orElse(this.iridiumTeams.getMessages().nullPlaceholder);
        this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().unInviteCommand, new String[]{username});
    }
}

