/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Setting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import java.util.Collections;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class SettingsGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private final IridiumTeams<T, U> iridiumTeams;
    private final T team;

    public SettingsGUI(T team, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().settingsGUI.background, player, iridiumTeams.getInventories().backButton);
        this.iridiumTeams = iridiumTeams;
        this.team = team;
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.iridiumTeams.getInventories().settingsGUI.size, (String)StringUtils.color(this.iridiumTeams.getInventories().settingsGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (Map.Entry<String, Setting> setting : this.iridiumTeams.getSettingsList().entrySet()) {
            TeamSetting teamSetting = this.iridiumTeams.getTeamManager().getTeamSetting(this.team, setting.getKey());
            if (teamSetting == null) continue;
            String teamSettingDisplay = teamSetting.getValue();
            switch (teamSetting.getValue()) {
                case "Enabled": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().enabledPlaceholder;
                    break;
                }
                case "Disabled": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().disabledPlaceholder;
                    break;
                }
                case "Private": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().privatePlaceholder;
                    break;
                }
                case "Public": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().publicPlaceholder;
                    break;
                }
                case "Server": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().serverPlaceholder;
                    break;
                }
                case "Sunny": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().sunnyPlaceholder;
                    break;
                }
                case "Raining": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().rainingPlaceholder;
                    break;
                }
                case "Sunrise": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().sunrisePlaceholder;
                    break;
                }
                case "Day": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().dayPlaceholder;
                    break;
                }
                case "Morning": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().morningPlaceholder;
                    break;
                }
                case "Noon": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().noonPlaceholder;
                    break;
                }
                case "Sunset": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().sunsetPlaceholder;
                    break;
                }
                case "Night": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().nightPlaceholder;
                    break;
                }
                case "Midnight": {
                    teamSettingDisplay = this.iridiumTeams.getMessages().midnightPlaceholder;
                }
            }
            inventory.setItem(setting.getValue().getItem().slot.intValue(), ItemStackUtils.makeItem(setting.getValue().getItem(), Collections.singletonList(new Placeholder("value", teamSettingDisplay))));
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        for (Map.Entry<String, Setting> setting : this.iridiumTeams.getSettingsList().entrySet()) {
            TeamSetting teamSetting;
            if (setting.getValue().getItem().slot.intValue() != event.getSlot() || (teamSetting = this.iridiumTeams.getTeamManager().getTeamSetting(this.team, setting.getKey())) == null) continue;
            int currentIndex = setting.getValue().getValues().indexOf(teamSetting.getValue());
            String newValue = setting.getValue().getValues().get(setting.getValue().getValues().size() > currentIndex + 1 ? currentIndex + 1 : 0);
            this.iridiumTeams.getCommandManager().executeCommand((CommandSender)event.getWhoClicked(), this.iridiumTeams.getCommands().settingsCommand, new String[]{setting.getValue().getDisplayName(), newValue});
            return;
        }
    }
}

