/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.gui;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.TopGUIConfig;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.sorting.TeamSorting;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class TopGUI<T extends Team, U extends IridiumUser<T>>
extends BackGUI {
    private TeamSorting<T> sortingType;
    private int page = 1;
    private final IridiumTeams<T, U> iridiumTeams;

    public TopGUI(TeamSorting<T> sortingType, Player player, IridiumTeams<T, U> iridiumTeams) {
        super(iridiumTeams.getInventories().topGUI.background, player, iridiumTeams.getInventories().backButton);
        this.sortingType = sortingType;
        this.iridiumTeams = iridiumTeams;
    }

    @NotNull
    public Inventory getInventory() {
        TopGUIConfig noItemGUI = this.iridiumTeams.getInventories().topGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)noItemGUI.size, (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        List<T> teams = this.iridiumTeams.getTeamManager().getTeams(this.sortingType, true);
        Iterator<Object> iterator = this.iridiumTeams.getConfiguration().teamTopSlots.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            int slot = this.iridiumTeams.getConfiguration().teamTopSlots.get(n);
            int actualRank = n + this.iridiumTeams.getConfiguration().teamTopSlots.size() * (this.page - 1);
            if (teams.size() >= actualRank) {
                Team team = (Team)teams.get(actualRank - 1);
                inventory.setItem(slot, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().topGUI.item, this.iridiumTeams.getTeamsPlaceholderBuilder().getPlaceholders(team)));
                continue;
            }
            inventory.setItem(slot, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().topGUI.filler));
        }
        for (TeamSorting teamSorting : this.iridiumTeams.getSortingTypes()) {
            inventory.setItem(teamSorting.getItem().slot.intValue(), ItemStackUtils.makeItem(teamSorting.getItem()));
        }
        inventory.setItem(inventory.getSize() - 3, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().nextPage));
        inventory.setItem(inventory.getSize() - 7, ItemStackUtils.makeItem(this.iridiumTeams.getInventories().previousPage));
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        if (event.getSlot() == this.iridiumTeams.getInventories().topGUI.size - 7 && this.page > 1) {
            --this.page;
            event.getWhoClicked().openInventory(this.getInventory());
            return;
        }
        if (event.getSlot() == this.iridiumTeams.getInventories().topGUI.size - 3 && this.iridiumTeams.getTeamManager().getTeams().size() >= 1 + this.iridiumTeams.getConfiguration().teamTopSlots.size() * this.page) {
            ++this.page;
            event.getWhoClicked().openInventory(this.getInventory());
        }
        this.iridiumTeams.getSortingTypes().stream().filter(sorting -> sorting.item.slot.intValue() == event.getSlot()).findFirst().ifPresent(sortingType -> {
            this.sortingType = sortingType;
            this.addContent(event.getInventory());
        });
    }

    @Generated
    public TeamSorting<T> getSortingType() {
        return this.sortingType;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public void setSortingType(TeamSorting<T> sortingType) {
        this.sortingType = sortingType;
    }

    @Generated
    public void setPage(int page) {
        this.page = page;
    }
}

