/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFertilizeEvent;

public class BlockFertilizeListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockFertilize(BlockFertilizeEvent event) {
        Player player = event.getPlayer();
        Optional<Team> currentTeam = this.iridiumTeams.getTeamManager().getTeamViaLocation(event.getBlock().getLocation());
        int currentTeamId = currentTeam.map(Team::getId).orElse(0);
        if (player != null && currentTeam.isPresent()) {
            U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
            if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)currentTeam.get(), user, PermissionType.BLOCK_PLACE)) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotBreakBlocks.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                event.setCancelled(true);
                return;
            }
        }
        event.getBlocks().removeIf(blockState -> {
            Optional<Team> team = this.iridiumTeams.getTeamManager().getTeamViaLocation(blockState.getLocation());
            return team.map(Team::getId).orElse(currentTeamId) != currentTeamId;
        });
    }

    @Generated
    public BlockFertilizeListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

