/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.listeners;

import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSpawners;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;

public class PlayerInteractListener<T extends Team, U extends IridiumUser<T>>
implements Listener {
    private final IridiumTeams<T, U> iridiumTeams;
    private final List<XMaterial> redstoneTriggers = Arrays.asList(XMaterial.LEVER, XMaterial.STRING, XMaterial.TRIPWIRE, XMaterial.TRIPWIRE_HOOK, XMaterial.SCULK_SENSOR, XMaterial.CALIBRATED_SCULK_SENSOR);

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Player player = event.getPlayer();
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player, event.getClickedBlock().getLocation()).ifPresent(team -> {
            if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)team, (IridiumUser)user, PermissionType.OPEN_CONTAINERS.getPermissionKey()) && event.getClickedBlock().getState() instanceof InventoryHolder) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotOpenContainers.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                event.setCancelled(true);
            }
            if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)team, (IridiumUser)user, PermissionType.DOORS.getPermissionKey()) && this.isDoor(XMaterial.matchXMaterial(event.getClickedBlock().getType()))) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotOpenDoors.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                event.setCancelled(true);
            }
            if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)team, (IridiumUser)user, PermissionType.REDSTONE.getPermissionKey()) && this.isRedstoneTrigger(XMaterial.matchXMaterial(event.getClickedBlock().getType()))) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotTriggerRedstone.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                event.setCancelled(true);
            }
            if (event.getAction() == Action.PHYSICAL) {
                TeamSetting cropTrampleTeamSetting = this.iridiumTeams.getTeamManager().getTeamSetting((Team)team, SettingType.CROP_TRAMPLE.getSettingKey());
                if (cropTrampleTeamSetting == null) {
                    return;
                }
                if (cropTrampleTeamSetting.getValue().equalsIgnoreCase("Disabled") && XMaterial.matchXMaterial(event.getClickedBlock().getType()) == XMaterial.FARMLAND) {
                    event.setCancelled(true);
                }
            }
            if (this.isSpawner(XMaterial.matchXMaterial(event.getClickedBlock().getType())) && (this.isSpawnEgg(event.getPlayer().getInventory().getItemInMainHand().getItemMeta()) || this.isSpawnEgg(event.getPlayer().getInventory().getItemInOffHand().getItemMeta()))) {
                if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)team, (IridiumUser)user, PermissionType.SPAWNERS.getPermissionKey())) {
                    player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotBreakSpawners.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                    event.setCancelled(true);
                } else {
                    TeamSpawners teamSpawners;
                    ItemStack itemStack = this.isSpawnEgg(event.getPlayer().getInventory().getItemInMainHand().getItemMeta()) ? event.getPlayer().getInventory().getItemInMainHand() : event.getPlayer().getInventory().getItemInOffHand();
                    CreatureSpawner creatureSpawner = (CreatureSpawner)event.getClickedBlock().getState();
                    EntityType newEntityType = this.getEntityType(itemStack);
                    if (newEntityType == EntityType.UNKNOWN) {
                        newEntityType = creatureSpawner.getSpawnedType();
                    }
                    if (creatureSpawner.getSpawnedType() != null) {
                        teamSpawners = this.iridiumTeams.getTeamManager().getTeamSpawners((Team)team, creatureSpawner.getSpawnedType());
                        teamSpawners.setAmount(Math.max(0, teamSpawners.getAmount() - 1));
                    }
                    teamSpawners = this.iridiumTeams.getTeamManager().getTeamSpawners((Team)team, newEntityType);
                    teamSpawners.setAmount(teamSpawners.getAmount() + 1);
                }
            }
        });
    }

    @EventHandler
    public void onSignChangeEvent(SignChangeEvent event) {
        Player player = event.getPlayer();
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player, event.getBlock().getLocation()).ifPresent(team -> {
            if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)team, (IridiumUser)user, PermissionType.INTERACT.getPermissionKey())) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotInteract.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                event.setCancelled(true);
            }
        });
    }

    @EventHandler
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        this.iridiumTeams.getTeamManager().getTeamViaPlayerLocation(player, event.getRightClicked().getLocation()).ifPresent(team -> {
            if (!this.iridiumTeams.getTeamManager().getTeamPermission((Team)team, (IridiumUser)user, PermissionType.INTERACT.getPermissionKey())) {
                player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().cannotInteract.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
                event.setCancelled(true);
            }
        });
    }

    private EntityType getEntityType(ItemStack itemStack) {
        try {
            return EntityType.valueOf((String)itemStack.getType().name().toUpperCase().replace("_SPAWN_EGG", ""));
        }
        catch (NullPointerException e) {
            this.iridiumTeams.getLogger().warning(e.getMessage());
            return EntityType.UNKNOWN;
        }
    }

    private boolean isSpawner(XMaterial material) {
        return material.name().toLowerCase().contains("spawner");
    }

    private boolean isSpawnEgg(ItemMeta itemMeta) {
        return itemMeta instanceof SpawnEggMeta;
    }

    private boolean isRedstoneTrigger(XMaterial material) {
        return this.redstoneTriggers.contains(material) || material.name().toLowerCase().contains("_button") || material.name().toLowerCase().contains("_pressure_plate");
    }

    private boolean isDoor(XMaterial material) {
        return material.name().toLowerCase().contains("_door") || material.name().toLowerCase().contains("fence_gate") || material.name().toLowerCase().contains("trapdoor");
    }

    @Generated
    public PlayerInteractListener(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }
}

