/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.managers;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.annotations.Nullable;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.PermissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Rank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.Reward;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.SettingType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.TemporaryCache;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.api.EnhancementUpdateEvent;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.BlockValues;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBlock;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamEnhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamInvite;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamMissionData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamReward;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSetting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamSpawners;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamTrust;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamWarp;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.Enhancement;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.enhancements.EnhancementData;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.Mission;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.missions.MissionType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.sorting.TeamSorting;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportType;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.utils.PlayerUtils;
import com.iridium.iridiumskyblock.dependencies.lib.PaperLib;
import com.iridium.iridiumskyblock.dependencies.nbtapi.NBT;
import com.iridium.iridiumskyblock.dependencies.nbtapi.NBTType;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public abstract class TeamManager<T extends Team, U extends IridiumUser<T>> {
    private final TemporaryCache<TeamSorting<T>, List<T>> teamTopCache = new TemporaryCache();
    private final TemporaryCache<T, Double> teamValueCache = new TemporaryCache();
    private final IridiumTeams<T, U> iridiumTeams;

    public TeamManager(IridiumTeams<T, U> iridiumTeams) {
        this.iridiumTeams = iridiumTeams;
    }

    public abstract Optional<T> getTeamViaID(int var1);

    public abstract Optional<T> getTeamViaName(String var1);

    public abstract Optional<T> getTeamViaLocation(Location var1);

    public abstract Optional<T> getTeamViaLocation(Location var1, T var2);

    public abstract Optional<T> getTeamViaLocation(Location var1, Optional<T> var2);

    public abstract Optional<T> getTeamViaNameOrPlayer(String var1);

    public Optional<T> getTeamViaPlayerLocation(Player player) {
        return this.getTeamViaPlayerLocation(player, player.getLocation());
    }

    public Optional<T> getTeamViaPlayerLocation(Player player, Location location) {
        return this.getTeamViaLocation(location);
    }

    public abstract void sendTeamTitle(Player var1, T var2);

    public boolean canVisit(Player player, T team) {
        TeamSetting teamSetting = this.getTeamSetting(team, SettingType.TEAM_VISITING.getSettingKey());
        if (teamSetting == null) {
            return true;
        }
        U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
        return ((IridiumUser)user).isBypassing() || ((IridiumUser)user).getTeamID() == ((Team)team).getId() || teamSetting.getValue().equalsIgnoreCase("Enabled");
    }

    public abstract List<T> getTeams();

    public List<T> getTeams(TeamSorting<T> sortType, boolean excludePrivate) {
        return this.teamTopCache.get(sortType, Duration.ofSeconds(10L), () -> sortType.getSortedTeams(this.iridiumTeams).stream().filter(team -> {
            TeamSetting teamSetting = this.getTeamSetting(team, SettingType.VALUE_VISIBILITY.getSettingKey());
            return !excludePrivate || teamSetting == null || teamSetting.getValue().equalsIgnoreCase("Public");
        }).collect(Collectors.toList()));
    }

    public int getRank(T team, TeamSorting<T> sortType) {
        List<T> teams = this.getTeams(sortType, true);
        return teams.indexOf(team) + 1;
    }

    public List<T> getTeams(SortType sortType, boolean excludePrivate) {
        switch (sortType) {
            case Value: {
                return this.getTeams(this.iridiumTeams.getTop().valueTeamSort, excludePrivate);
            }
            case Experience: {
                return this.getTeams(this.iridiumTeams.getTop().experienceTeamSort, excludePrivate);
            }
        }
        return this.getTeams();
    }

    public List<U> getTeamMembers(T team) {
        return this.iridiumTeams.getUserManager().getUsers().stream().filter(user -> user.getTeamID() == team.getId()).collect(Collectors.toList());
    }

    public abstract boolean isInTeam(T var1, Location var2);

    public abstract CompletableFuture<T> createTeam(@NotNull Player var1, @Nullable String var2);

    public abstract boolean deleteTeam(T var1, U var2);

    public int getUserRank(T team, U user) {
        if (((IridiumUser)user).getTeamID() == ((Team)team).getId()) {
            return ((IridiumUser)user).getUserRank();
        }
        return Rank.VISITOR.getId();
    }

    public abstract boolean getTeamPermission(T var1, int var2, String var3);

    public abstract void setTeamPermission(T var1, int var2, String var3, boolean var4);

    public boolean getTeamPermission(T team, U user, String permission) {
        if (((IridiumUser)user).isBypassing()) {
            return true;
        }
        if (this.getTeamTrust(team, user).isPresent() && this.getTeamPermission(team, true, permission)) {
            return true;
        }
        return this.getTeamPermission(team, (U)this.getUserRank(team, user), permission);
    }

    public boolean getTeamPermission(T team, U user, PermissionType permissionType) {
        return this.getTeamPermission(team, user, permissionType.getPermissionKey());
    }

    public boolean getTeamPermission(Location location, U user, String permission) {
        return this.getTeamViaLocation(location).map(team -> this.getTeamPermission(team, user, permission)).orElse(true);
    }

    public abstract Optional<TeamInvite> getTeamInvite(T var1, U var2);

    public abstract List<TeamInvite> getTeamInvites(T var1);

    public abstract void createTeamInvite(T var1, U var2, U var3);

    public abstract void deleteTeamInvite(TeamInvite var1);

    public abstract Optional<TeamTrust> getTeamTrust(T var1, U var2);

    public abstract List<TeamTrust> getTeamTrusts(T var1);

    public abstract void createTeamTrust(T var1, U var2, U var3);

    public abstract void deleteTeamTrust(TeamTrust var1);

    public abstract TeamBank getTeamBank(T var1, String var2);

    public abstract TeamSpawners getTeamSpawners(T var1, EntityType var2);

    public abstract TeamBlock getTeamBlock(T var1, XMaterial var2);

    @Nullable
    public abstract TeamSetting getTeamSetting(T var1, String var2);

    public int getTeamLevel(int experience) {
        if (!this.iridiumTeams.getConfiguration().enableLeveling) {
            return 1;
        }
        int flatExpRequirement = this.iridiumTeams.getConfiguration().flatExpRequirement;
        double curvedExpModifier = this.iridiumTeams.getConfiguration().curvedExpModifier;
        if (flatExpRequirement == 0) {
            flatExpRequirement = 1;
        }
        if (curvedExpModifier == 0.0) {
            curvedExpModifier = 1.0;
        }
        return Math.max(1, (int)Math.floor(Math.pow((double)experience / (double)Math.abs(flatExpRequirement), Math.abs(curvedExpModifier)) + 1.0));
    }

    public int getExperienceForLevel(int level) {
        int flatExpRequirement = this.iridiumTeams.getConfiguration().flatExpRequirement;
        double curvedExpModifier = this.iridiumTeams.getConfiguration().curvedExpModifier;
        if (flatExpRequirement == 0) {
            flatExpRequirement = 1;
        }
        if (curvedExpModifier == 0.0) {
            curvedExpModifier = 1.0;
        }
        return (int)Math.floor((double)Math.abs(flatExpRequirement) * Math.pow(10.0, Math.log10(level - 1) / Math.abs(curvedExpModifier)));
    }

    public int getTeamExperienceForNextLevel(T team) {
        return this.getExperienceForLevel(((Team)team).getLevel() + 1) - ((Team)team).getExperience();
    }

    public double getTeamValue(T team) {
        return this.teamValueCache.get(team, Duration.ofSeconds(1L), () -> {
            double value = 0.0;
            for (Map.Entry<XMaterial, BlockValues.ValuableBlock> entry : this.iridiumTeams.getBlockValues().blockValues.entrySet()) {
                value += (double)this.getTeamBlock(team, entry.getKey()).getAmount() * entry.getValue().value;
            }
            for (Map.Entry<XMaterial, BlockValues.ValuableBlock> entry : this.iridiumTeams.getBlockValues().spawnerValues.entrySet()) {
                value += (double)this.getTeamSpawners(team, (EntityType)entry.getKey()).getAmount() * entry.getValue().value;
            }
            return value;
        });
    }

    public abstract TeamEnhancement getTeamEnhancement(T var1, String var2);

    public boolean UpdateEnhancement(T team, String booster, Player player) {
        EnhancementData enhancementData;
        Enhancement<?> enhancement = this.iridiumTeams.getEnhancementList().get(booster);
        TeamEnhancement teamEnhancement = this.getTeamEnhancement(team, booster);
        if (!teamEnhancement.isActive(enhancement.type)) {
            teamEnhancement.setLevel(0);
        }
        if ((enhancementData = (EnhancementData)enhancement.levels.get(teamEnhancement.getLevel() + 1)) == null) {
            enhancementData = (EnhancementData)enhancement.levels.get(teamEnhancement.getLevel());
        }
        if (enhancementData.minLevel > ((Team)team).getLevel()) {
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().notHighEnoughLevel.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix).replace("%level%", String.valueOf(enhancementData.minLevel))));
            return false;
        }
        if (this.iridiumTeams.getEconomy().getBalance((OfflinePlayer)player) < (double)enhancementData.money) {
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().notEnoughMoney.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix)));
            return false;
        }
        for (Map.Entry<String, Double> bankCost : enhancementData.bankCosts.entrySet()) {
            if (!(this.getTeamBank(team, bankCost.getKey()).getNumber() < bankCost.getValue())) continue;
            player.sendMessage(StringUtils.color(this.iridiumTeams.getMessages().notEnoughBankItem.replace("%prefix%", this.iridiumTeams.getConfiguration().prefix).replace("%bank%", bankCost.getKey())));
            return false;
        }
        this.iridiumTeams.getEconomy().withdrawPlayer((OfflinePlayer)player, (double)enhancementData.money);
        for (Map.Entry<String, Double> bankCost : enhancementData.bankCosts.entrySet()) {
            TeamBank teamBank = this.getTeamBank(team, bankCost.getKey());
            teamBank.setNumber(teamBank.getNumber() - bankCost.getValue());
        }
        if (enhancement.levels.containsKey(teamEnhancement.getLevel() + 1)) {
            U user = this.iridiumTeams.getUserManager().getUser((OfflinePlayer)player);
            EnhancementUpdateEvent<T, U> enhancementUpdateEvent = new EnhancementUpdateEvent<T, U>(team, user, teamEnhancement.getLevel() + 1, booster);
            Bukkit.getPluginManager().callEvent(enhancementUpdateEvent);
            if (enhancementUpdateEvent.isCancelled()) {
                return false;
            }
            teamEnhancement.setLevel(enhancementUpdateEvent.getNextLevel());
        }
        if (teamEnhancement.getExpirationTime().isBefore(LocalDateTime.now())) {
            teamEnhancement.setExpirationTime(LocalDateTime.now().plusHours(1L));
        } else {
            teamEnhancement.setExpirationTime(teamEnhancement.getExpirationTime().plusHours(1L));
        }
        return true;
    }

    public abstract CompletableFuture<Void> recalculateTeam(T var1);

    public abstract void createWarp(T var1, UUID var2, Location var3, String var4, String var5);

    public abstract void deleteWarp(TeamWarp var1);

    public abstract List<TeamWarp> getTeamWarps(T var1);

    public abstract Optional<TeamWarp> getTeamWarp(T var1, String var2);

    public abstract List<TeamMission> getTeamMissions(T var1);

    public abstract TeamMission getTeamMission(T var1, String var2);

    public abstract TeamMissionData getTeamMissionData(TeamMission var1, int var2);

    public abstract List<TeamMissionData> getTeamMissionData(TeamMission var1);

    public abstract void deleteTeamMission(TeamMission var1);

    public abstract void deleteTeamMissionData(TeamMission var1);

    public void resetTeamMissionData(TeamMission teamMission) {
        this.getTeamMissionData(teamMission).forEach(teamMissionData -> teamMissionData.setProgress(0));
    }

    public List<String> getTeamMission(T team, MissionType missionType) {
        List teamMissions = this.getTeamMissions(team).stream().filter(teamMission -> this.iridiumTeams.getMissions().missions.containsKey(teamMission.getMissionName())).filter(teamMission -> this.iridiumTeams.getMissions().missions.get(teamMission.getMissionName()).getMissionType() == missionType).filter(teamMission -> this.iridiumTeams.getMissions().missions.get((Object)teamMission.getMissionName()).getMissionData().get((Object)Integer.valueOf((int)teamMission.getMissionLevel())).getItem().slot == null).collect(Collectors.toList());
        ArrayList<String> missions = new ArrayList<String>();
        for (TeamMission teamMission2 : teamMissions) {
            if (teamMission2.hasExpired()) {
                this.deleteTeamMission(teamMission2);
                this.deleteTeamMissionData(teamMission2);
                continue;
            }
            missions.add(teamMission2.getMissionName());
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        List availableMissions = this.iridiumTeams.getMissions().missions.entrySet().stream().filter(mission -> !((Mission)mission.getValue()).getMissionData().isEmpty()).filter(mission -> ((Mission)mission.getValue()).getMissionData().get((Object)Integer.valueOf((int)1)).getItem().slot == null).filter(mission -> ((Mission)mission.getValue()).getMissionType() == missionType).filter(mission -> !missions.contains(mission.getKey())).collect(Collectors.toList());
        while (missions.size() < this.iridiumTeams.getMissions().dailySlots.size() && availableMissions.size() > 0) {
            Map.Entry newMission = (Map.Entry)availableMissions.get(random.nextInt(availableMissions.size()));
            missions.add((String)newMission.getKey());
            availableMissions.remove(newMission);
        }
        return missions;
    }

    public abstract List<TeamReward> getTeamRewards(T var1);

    public abstract void addTeamReward(TeamReward var1);

    public abstract void deleteTeamReward(TeamReward var1);

    public synchronized void claimTeamReward(TeamReward teamReward, Player player) {
        Reward reward = teamReward.getReward();
        this.deleteTeamReward(teamReward);
        reward.sound.play((Entity)player);
        this.iridiumTeams.getEconomy().depositPlayer((OfflinePlayer)player, reward.money);
        PlayerUtils.setTotalExperience(player, PlayerUtils.getTotalExperience(player) + reward.experience);
        this.getTeamViaID(teamReward.getTeamID()).ifPresent(team -> {
            team.setExperience(team.getExperience() + reward.teamExperience);
            for (Map.Entry<String, Double> entry : reward.bankRewards.entrySet()) {
                TeamBank teamBank = this.getTeamBank(team, entry.getKey());
                teamBank.setNumber(teamBank.getNumber() + entry.getValue());
            }
        });
        reward.commands.forEach(command -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command.replace("%player%", player.getName())));
    }

    public void sendTeamTime(Player player) {
        this.getTeamViaPlayerLocation(player).ifPresent(team -> {
            TeamSetting teamSetting = this.getTeamSetting(team, SettingType.TIME.getSettingKey());
            if (teamSetting == null) {
                return;
            }
            switch (teamSetting.getValue().toLowerCase()) {
                case "sunrise": {
                    this.setPlayerTime(player, 0L, false);
                    return;
                }
                case "day": {
                    this.setPlayerTime(player, 1000L, false);
                    return;
                }
                case "morning": {
                    this.setPlayerTime(player, 6000L, false);
                    return;
                }
                case "noon": {
                    this.setPlayerTime(player, 9000L, false);
                    return;
                }
                case "sunset": {
                    this.setPlayerTime(player, 12000L, false);
                    return;
                }
                case "night": {
                    this.setPlayerTime(player, 13000L, false);
                    return;
                }
                case "midnight": {
                    this.setPlayerTime(player, 18000L, false);
                    return;
                }
            }
            this.setPlayerTime(player, 0L, true);
        });
    }

    public void sendTeamWeather(Player player) {
        this.getTeamViaPlayerLocation(player).ifPresent(team -> {
            TeamSetting teamSetting = this.getTeamSetting(team, SettingType.WEATHER.getSettingKey());
            if (teamSetting == null) {
                return;
            }
            switch (teamSetting.getValue().toLowerCase()) {
                case "sunny": {
                    this.setPlayerWeather(player, WeatherType.CLEAR);
                    return;
                }
                case "raining": {
                    this.setPlayerWeather(player, WeatherType.DOWNFALL);
                    return;
                }
            }
            player.resetPlayerWeather();
        });
    }

    private void setPlayerTime(Player player, long time, boolean relative) {
        if (player.isPlayerTimeRelative() != relative || player.getPlayerTime() != time) {
            player.setPlayerTime(time, relative);
        }
    }

    private void setPlayerWeather(Player player, WeatherType weatherType) {
        if (player.getPlayerWeather() != weatherType) {
            player.setPlayerWeather(weatherType);
        }
    }

    public boolean teleport(Player player, Location location, T team) {
        player.setFallDistance(0.0f);
        PaperLib.teleportAsync((Entity)player, location);
        player.teleport(location);
        return true;
    }

    public boolean teleportWithDelay(Player player, Location location, T team, TeleportType teleportType, String teleportName) {
        return this.iridiumTeams.getTeleportManager().startTeleport(player, location, team, teleportType, teleportName);
    }

    public boolean teleportToHome(Player player, Location location, T team) {
        return this.teleportWithDelay(player, location, team, TeleportType.HOME, "home");
    }

    public boolean teleportToWarp(Player player, Location location, T team, String warpName) {
        return this.teleportWithDelay(player, location, team, TeleportType.WARP, warpName);
    }

    public void handleBlockBreakOutsideTerritory(BlockBreakEvent blockEvent) {
    }

    public void handleBlockPlaceOutsideTerritory(BlockPlaceEvent blockEvent) {
    }

    public boolean isBankItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return NBT.get(item, readableItemNBT -> readableItemNBT.hasTag(this.iridiumTeams.getName().toLowerCase(), NBTType.NBTTagCompound));
    }

    public static enum SortType {
        Experience,
        Value;

    }
}

