/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport;

import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.Team;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.teleport.TeleportType;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportRequest<T extends Team, U extends IridiumUser<T>> {
    private final UUID playerId;
    private final Location destination;
    private final Location originalLocation;
    private final LocalDateTime requestTime;
    private final TeleportType teleportType;
    private final T team;
    private final String teleportName;
    private BukkitRunnable delayTask;
    private BukkitRunnable countdownTask;
    private int remainingSeconds;

    public TeleportRequest(UUID playerId, Location destination, Location originalLocation, TeleportType teleportType, T team, String teleportName, int delaySeconds) {
        this.playerId = playerId;
        this.destination = destination;
        this.originalLocation = originalLocation;
        this.requestTime = LocalDateTime.now();
        this.teleportType = teleportType;
        this.team = team;
        this.teleportName = teleportName;
        this.remainingSeconds = delaySeconds;
        this.delayTask = null;
        this.countdownTask = null;
    }

    public Optional<Player> getPlayer() {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)this.playerId));
    }

    public boolean hasPlayerMoved(double threshold) {
        Optional<Player> optionalPlayer = this.getPlayer();
        if (!optionalPlayer.isPresent()) {
            return true;
        }
        Player player = optionalPlayer.get();
        Location currentLocation = player.getLocation();
        if (!currentLocation.getWorld().equals(this.originalLocation.getWorld())) {
            return true;
        }
        double distance = currentLocation.distance(this.originalLocation);
        return distance > threshold;
    }

    public void cancelTasks() {
        if (this.delayTask != null && !this.delayTask.isCancelled()) {
            this.delayTask.cancel();
        }
        if (this.countdownTask != null && !this.countdownTask.isCancelled()) {
            this.countdownTask.cancel();
        }
    }

    @Generated
    public TeleportRequest(UUID playerId, Location destination, Location originalLocation, LocalDateTime requestTime, TeleportType teleportType, T team, String teleportName, BukkitRunnable delayTask, BukkitRunnable countdownTask, int remainingSeconds) {
        this.playerId = playerId;
        this.destination = destination;
        this.originalLocation = originalLocation;
        this.requestTime = requestTime;
        this.teleportType = teleportType;
        this.team = team;
        this.teleportName = teleportName;
        this.delayTask = delayTask;
        this.countdownTask = countdownTask;
        this.remainingSeconds = remainingSeconds;
    }

    @Generated
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Generated
    public Location getDestination() {
        return this.destination;
    }

    @Generated
    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    @Generated
    public LocalDateTime getRequestTime() {
        return this.requestTime;
    }

    @Generated
    public TeleportType getTeleportType() {
        return this.teleportType;
    }

    @Generated
    public T getTeam() {
        return this.team;
    }

    @Generated
    public String getTeleportName() {
        return this.teleportName;
    }

    @Generated
    public BukkitRunnable getDelayTask() {
        return this.delayTask;
    }

    @Generated
    public BukkitRunnable getCountdownTask() {
        return this.countdownTask;
    }

    @Generated
    public int getRemainingSeconds() {
        return this.remainingSeconds;
    }

    @Generated
    public void setDelayTask(BukkitRunnable delayTask) {
        this.delayTask = delayTask;
    }

    @Generated
    public void setCountdownTask(BukkitRunnable countdownTask) {
        this.countdownTask = countdownTask;
    }

    @Generated
    public void setRemainingSeconds(int remainingSeconds) {
        this.remainingSeconds = remainingSeconds;
    }
}

