/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.iridiumteams.utils;

import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.IridiumCore;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.multiversion.MultiVersion;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.IridiumTeams;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class LocationUtils {
    private static boolean isSafeTesting = true;
    private static final List<Material> unsafeBlocks = Stream.of(XMaterial.END_PORTAL, XMaterial.WATER, XMaterial.LAVA).map(XMaterial::parseMaterial).collect(Collectors.toList());

    public static boolean isSafe(@NotNull Location location, IridiumTeams<?, ?> iridiumTeams) {
        if (IridiumCore.isTesting()) {
            boolean safe = isSafeTesting;
            isSafeTesting = true;
            return safe;
        }
        Block block = location.getBlock();
        Block above = location.clone().add(0.0, 1.0, 0.0).getBlock();
        Block below = location.clone().subtract(0.0, 1.0, 0.0).getBlock();
        MultiVersion multiVersion = iridiumTeams.getMultiVersion();
        return multiVersion.isPassable(block) && multiVersion.isPassable(above) && !multiVersion.isPassable(below) && !unsafeBlocks.contains(below.getType()) && !unsafeBlocks.contains(block.getType()) && !unsafeBlocks.contains(above.getType());
    }

    public static int getMinHeight(World world) {
        return XMaterial.getVersion() >= 17 ? world.getMinHeight() : 0;
    }

    @Generated
    public static void setSafeTesting(boolean isSafeTesting) {
        LocationUtils.isSafeTesting = isSafeTesting;
    }
}

