/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.db;

import com.iridium.iridiumskyblock.dependencies.ormlite.db.BaseDatabaseType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.DataPersister;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldConverter;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.FieldType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.SqlType;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.converter.BooleanNumberFieldConverter;
import com.iridium.iridiumskyblock.dependencies.ormlite.field.types.BigDecimalStringType;
import java.util.List;

public abstract class BaseSqliteDatabaseType
extends BaseDatabaseType {
    @Override
    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (fieldType.getSqlType() == SqlType.LONG && fieldType.isGeneratedId()) {
            sb.append("INTEGER");
        } else {
            sb.append("BIGINT");
        }
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        if (fieldType.getSqlType() != SqlType.INTEGER && fieldType.getSqlType() != SqlType.LONG) {
            throw new IllegalArgumentException("Sqlite requires that auto-increment generated-id be integer or long type");
        }
        sb.append("PRIMARY KEY AUTOINCREMENT ");
    }

    @Override
    protected boolean generatedIdSqlAtEnd() {
        return false;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return false;
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return false;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return true;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister, FieldType fieldType) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                return BooleanNumberFieldConverter.getSingleton();
            }
            case BIG_DECIMAL: {
                return BigDecimalStringType.getSingleton();
            }
        }
        return super.getFieldConverter(dataPersister, fieldType);
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("DEFAULT VALUES");
    }
}

