/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.dependencies.ormlite.logger;

import com.iridium.iridiumskyblock.dependencies.ormlite.logger.ConsoleLogBackend;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.Level;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.LocalLogBackend;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.LogBackend;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.LogBackendFactory;
import com.iridium.iridiumskyblock.dependencies.ormlite.logger.NullLogBackend;

public enum LogBackendType implements LogBackendFactory
{
    SLF4J("com.iridium.iridiumskyblock.dependencies.ormlite.logger.Slf4jLoggingLogBackend$Slf4jLoggingLogBackendFactory"),
    ANDROID("com.iridium.iridiumskyblock.dependencies.ormlite.android.AndroidLogBackend$AndroidLogBackendFactory"),
    LOGBACK("com.iridium.iridiumskyblock.dependencies.ormlite.logger.LogbackLogBackend$LogbackLogBackendFactory"),
    COMMONS_LOGGING("com.iridium.iridiumskyblock.dependencies.ormlite.logger.CommonsLoggingLogBackend$CommonsLoggingLogBackendFactory"),
    LOG4J2("com.iridium.iridiumskyblock.dependencies.ormlite.logger.Log4j2LogBackend$Log4j2LogBackendFactory"),
    LOG4J("com.iridium.iridiumskyblock.dependencies.ormlite.logger.Log4jLogBackend$Log4jLogBackendFactory"),
    LOCAL(new LocalLogBackend.LocalLogBackendFactory()),
    CONSOLE(new ConsoleLogBackend.ConsoleLogBackendFactory()),
    JAVA_UTIL("com.iridium.iridiumskyblock.dependencies.ormlite.logger.JavaUtilLogBackend$JavaUtilLogBackendFactory"),
    NULL(new NullLogBackend.NullLogBackendFactory());

    private final LogBackendFactory factory;

    private LogBackendType(LogBackendFactory factory) {
        this.factory = factory;
    }

    private LogBackendType(String logBackendFactoryClassName) {
        this.factory = this.detectFactory(logBackendFactoryClassName);
    }

    @Override
    public LogBackend createLogBackend(String classLabel) {
        return this.factory.createLogBackend(classLabel);
    }

    public boolean isAvailable() {
        return this == LOCAL || this != NULL && !(this.factory instanceof LocalLogBackend.LocalLogBackendFactory);
    }

    private LogBackendFactory detectFactory(String factoryClassName) {
        try {
            LogBackendFactory factory = (LogBackendFactory)Class.forName(factoryClassName).newInstance();
            factory.createLogBackend("test").isLevelEnabled(Level.INFO);
            return factory;
        }
        catch (Throwable th) {
            String queuedWarning = "Unable to create instance of class " + factoryClassName + " for log type " + this + ", using local log: " + th.getMessage();
            return new LocalLogBackend.LocalLogBackendFactory(queuedWarning);
        }
    }
}

