/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.generators;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Generators;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.iridium.iridiumskyblock.utils.LocationUtils;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;

public class FlatGenerator
extends ChunkGenerator {
    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.BiomeGrid biomeGrid) {
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        int floorHeight = this.getFlatGenerator((World.Environment)world.getEnvironment()).floorHeight;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunkData.setBlock(x, LocationUtils.getMinHeight(world), z, Objects.requireNonNull(XMaterial.BEDROCK.parseMaterial()));
                for (int y = LocationUtils.getMinHeight(world) + 1; y < floorHeight; ++y) {
                    chunkData.setBlock(x, y, z, Objects.requireNonNull(this.getFlatGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial()));
                }
                chunkData.setBlock(x, floorHeight, z, Objects.requireNonNull(this.getFlatGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial()));
                biomeGrid.setBiome(x, z, Objects.requireNonNull(this.getFlatGenerator((World.Environment)world.getEnvironment()).biome.getBiome()));
            }
        }
        return chunkData;
    }

    public void generateFlatland(World world, int x, int z) {
        Block block;
        int y;
        Random random = new Random(world.getSeed());
        int floorHeight = this.getFlatGenerator((World.Environment)world.getEnvironment()).floorHeight;
        int minFloorHeight = world.getMinHeight();
        if (world.getBlockAt(x, minFloorHeight, z).getType() != XMaterial.BEDROCK.parseMaterial()) {
            if (world.getBlockAt(x, minFloorHeight, z).getState() instanceof InventoryHolder) {
                ((InventoryHolder)world.getBlockAt(x, minFloorHeight, z).getState()).getInventory().clear();
            }
            world.getBlockAt(x, minFloorHeight, z).setType(Material.BEDROCK, false);
        }
        for (y = minFloorHeight + 1; y < floorHeight; ++y) {
            block = world.getBlockAt(x, y, z);
            if (block.getType() == this.getFlatGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial() || this.getFlatGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial() == null) continue;
            if (block.getState() instanceof InventoryHolder) {
                ((InventoryHolder)block.getState()).getInventory().clear();
            }
            block.setType(Objects.requireNonNull(this.getFlatGenerator((World.Environment)world.getEnvironment()).underFloor.parseMaterial()), false);
        }
        if (world.getBlockAt(x, floorHeight, z).getType() != this.getFlatGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial() && this.getFlatGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial() != null) {
            if (world.getBlockAt(x, floorHeight, z).getState() instanceof InventoryHolder) {
                ((InventoryHolder)world.getBlockAt(x, floorHeight, z).getState()).getInventory().clear();
            }
            world.getBlockAt(x, floorHeight, z).setType(Objects.requireNonNull(this.getFlatGenerator((World.Environment)world.getEnvironment()).floor.parseMaterial()), false);
        }
        for (y = floorHeight + 1; y < world.getMaxHeight(); ++y) {
            block = world.getBlockAt(x, y, z);
            if (block.getType() == Material.AIR) continue;
            if (block.getState() instanceof InventoryHolder) {
                ((InventoryHolder)block.getState()).getInventory().clear();
            }
            block.setType(Material.AIR, false);
        }
    }

    public boolean shouldGenerateDecorations(@NotNull WorldInfo worldInfo, @NotNull Random random, int x, int z) {
        return this.getFlatGenerator((World.Environment)worldInfo.getEnvironment()).decorate;
    }

    public boolean canSpawn(@NotNull World world, int x, int z) {
        return this.getFlatGenerator((World.Environment)world.getEnvironment()).canSpawnEntities;
    }

    private Generators.FlatGeneratorWorld getFlatGenerator(World.Environment environment) {
        switch (environment) {
            case NETHER: {
                return IridiumSkyblock.getInstance().getGenerators().flatGenerator.nether;
            }
            case THE_END: {
                return IridiumSkyblock.getInstance().getGenerators().flatGenerator.end;
            }
        }
        return IridiumSkyblock.getInstance().getGenerators().flatGenerator.overworld;
    }
}

