/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.gui;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Schematics;
import com.iridium.iridiumskyblock.dependencies.annotations.NotNull;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.gui.BackGUI;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.ItemStackUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.Placeholder;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.configs.inventories.NoItemGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class SchematicGUI
extends BackGUI {
    public SchematicGUI(Player player) {
        super(IridiumSkyblock.getInstance().getInventories().islandSchematicGUI.background, player, IridiumSkyblock.getInstance().getInventories().backButton);
    }

    @NotNull
    public Inventory getInventory() {
        NoItemGUI noItemGUI = IridiumSkyblock.getInstance().getInventories().islandSchematicGUI;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)noItemGUI.size, (String)StringUtils.color(noItemGUI.title));
        this.addContent(inventory);
        return inventory;
    }

    @Override
    public void addContent(Inventory inventory) {
        super.addContent(inventory);
        for (Map.Entry<String, Schematics.SchematicConfig> entry : IridiumSkyblock.getInstance().getSchematics().schematics.entrySet()) {
            ItemStack itemStack = ItemStackUtils.makeItem(entry.getValue().item);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta != null) {
                itemMeta.setLore(this.getSchematicLore(entry.getValue()));
                itemStack.setItemMeta(itemMeta);
            }
            inventory.setItem(entry.getValue().item.slot.intValue(), itemStack);
        }
    }

    private List<String> getSchematicLore(Schematics.SchematicConfig item) {
        List<Placeholder> placeholders = this.getSchematicLorePlaceholders(item);
        ArrayList<String> lore = new ArrayList<String>(item.item.lore);
        if (item.regenCost.canPurchase()) {
            lore.add(String.valueOf(IridiumSkyblock.getInstance().getSchematics().buyPriceLore));
        }
        if (item.minLevel > 1) {
            lore.add(IridiumSkyblock.getInstance().getSchematics().levelRequirementLore);
        }
        if (!IridiumSkyblock.getInstance().getConfiguration().islandCreationCost) {
            lore.add(IridiumSkyblock.getInstance().getSchematics().regenDisclaimer);
        }
        return StringUtils.color(StringUtils.processMultiplePlaceholders(lore, placeholders));
    }

    private List<Placeholder> getSchematicLorePlaceholders(Schematics.SchematicConfig item) {
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>(Arrays.asList(new Placeholder("vault_cost", IridiumSkyblock.getInstance().getSchematicManager().formatPrice(item.regenCost.money)), new Placeholder("level", String.valueOf(item.minLevel))));
        for (Map.Entry<String, Double> bankItem : item.regenCost.bankItems.entrySet()) {
            placeholders.add(new Placeholder(bankItem.getKey() + "_cost", IridiumSkyblock.getInstance().getSchematicManager().formatPrice(bankItem.getValue())));
        }
        return placeholders;
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        super.onInventoryClick(event);
        for (Map.Entry<String, Schematics.SchematicConfig> entry : IridiumSkyblock.getInstance().getSchematics().schematics.entrySet()) {
            if (entry.getValue().item.slot.intValue() != event.getSlot()) continue;
            this.selectSchematic(entry.getKey());
            event.getWhoClicked().closeInventory();
        }
    }

    public abstract void selectSchematic(String var1);
}

