/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.listeners;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.RandomAccessList;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import com.iridium.iridiumskyblock.enhancements.GeneratorEnhancementData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;

public class BlockFormListener
implements Listener {
    private final Map<Integer, RandomAccessList<XMaterial>> normalOreLevels = new HashMap<Integer, RandomAccessList<XMaterial>>();
    private final Map<Integer, RandomAccessList<XMaterial>> netherOreLevels = new HashMap<Integer, RandomAccessList<XMaterial>>();
    private final List<XMaterial> generatorMaterials = Arrays.asList(XMaterial.STONE, XMaterial.COBBLESTONE, XMaterial.BASALT);

    public BlockFormListener() {
        for (Map.Entry oreUpgrade : IridiumSkyblock.getInstance().getEnhancements().generatorEnhancement.levels.entrySet()) {
            this.normalOreLevels.put(oreUpgrade.getKey(), new RandomAccessList<XMaterial>(((GeneratorEnhancementData)oreUpgrade.getValue()).ores));
            this.netherOreLevels.put(oreUpgrade.getKey(), new RandomAccessList<XMaterial>(((GeneratorEnhancementData)oreUpgrade.getValue()).netherOres));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        XMaterial newMaterial = XMaterial.matchXMaterial(event.getNewState().getType());
        if (!this.generatorMaterials.contains(newMaterial)) {
            return;
        }
        IridiumSkyblock.getInstance().getIslandManager().getTeamViaLocation(event.getNewState().getLocation()).ifPresent(island -> {
            RandomAccessList<XMaterial> randomMaterialList;
            int upgradeLevel = IridiumSkyblock.getInstance().getIslandManager().getTeamEnhancement((Island)island, "generator").getLevel();
            boolean isBasaltGenerator = newMaterial == XMaterial.BASALT;
            RandomAccessList<XMaterial> randomAccessList = randomMaterialList = isBasaltGenerator ? this.netherOreLevels.get(upgradeLevel) : this.normalOreLevels.get(upgradeLevel);
            if (randomMaterialList == null) {
                return;
            }
            Optional<XMaterial> xMaterialOptional = randomMaterialList.nextElement();
            if (!xMaterialOptional.isPresent()) {
                return;
            }
            if (isBasaltGenerator && IridiumSkyblock.getInstance().getConfiguration().netherOnlyGenerator && event.getNewState().getWorld().getEnvironment() != World.Environment.NETHER) {
                return;
            }
            Material material = xMaterialOptional.get().parseMaterial();
            if (material == Material.COBBLESTONE && newMaterial == XMaterial.STONE) {
                material = Material.STONE;
            }
            if (material != null) {
                event.getNewState().setType(material);
            }
        });
    }
}

