/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.managers;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.configs.Biomes;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.database.User;
import com.iridium.iridiumskyblock.dependencies.commons.lang.WordUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.utils.StringUtils;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.IridiumUser;
import com.iridium.iridiumskyblock.dependencies.iridiumteams.database.TeamBank;
import com.iridium.iridiumskyblock.dependencies.xseries.XBiome;
import java.util.Optional;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BiomeManager {
    public void buy(Player player, Biomes.BiomeItem biomeItem) {
        XBiome biome = biomeItem.biome;
        User user = IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player);
        Optional<Island> island = user.getIsland();
        if (!this.canPurchase(player, biomeItem)) {
            IridiumSkyblock.getInstance().getBiomes().failSound.play((Entity)player);
            return;
        }
        if (!island.isPresent()) {
            player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().dontHaveTeam.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
            return;
        }
        this.purchase(player, biomeItem);
        IridiumSkyblock.getInstance().getCommands().biomeCommand.getCooldownProvider().applyCooldown(player);
        IridiumSkyblock.getInstance().getIslandManager().setIslandBiome(island.get(), biome);
        IridiumSkyblock.getInstance().getTeamManager().getTeamMembers(island.get()).stream().map(IridiumUser::getPlayer).forEach(teamMember -> {
            if (teamMember != null) {
                teamMember.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().changedBiome.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix).replace("%player%", player.getName()).replace("%biome%", WordUtils.capitalizeFully(biome.friendlyName()))));
            }
        });
        IridiumSkyblock.getInstance().getBiomes().successSound.play((Entity)player);
    }

    private double getBankBalance(Player player, String bankItem) {
        User user = IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player);
        return IridiumSkyblock.getInstance().getTeamManager().getTeamViaID(user.getTeamID()).map(team -> IridiumSkyblock.getInstance().getTeamManager().getTeamBank((Island)team, bankItem)).map(TeamBank::getNumber).orElse(0.0);
    }

    private void setBankBalance(Player player, String bankItem, double amount) {
        User user = IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player);
        Optional<Island> team = IridiumSkyblock.getInstance().getTeamManager().getTeamViaID(user.getTeamID());
        if (!team.isPresent()) {
            return;
        }
        IridiumSkyblock.getInstance().getTeamManager().getTeamBank(team.get(), bankItem).setNumber(amount);
    }

    private boolean canPurchase(Player player, Biomes.BiomeItem biomeItem) {
        if (biomeItem.minLevel > 1) {
            User user = IridiumSkyblock.getInstance().getUserManager().getUser((OfflinePlayer)player);
            Optional<Island> island = IridiumSkyblock.getInstance().getIslandManager().getTeamViaID(user.getTeamID());
            if (!island.isPresent()) {
                player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().dontHaveTeam.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
                return false;
            }
            if (island.get().getLevel() < biomeItem.minLevel) {
                player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().notHighEnoughLevel.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix).replace("%level%", String.valueOf(biomeItem.minLevel))));
                return false;
            }
        }
        double moneyCost = biomeItem.buyCost.money;
        Economy economy = IridiumSkyblock.getInstance().getEconomy();
        for (String bankItem : biomeItem.buyCost.bankItems.keySet()) {
            double cost = biomeItem.buyCost.bankItems.get(bankItem);
            if (!(this.getBankBalance(player, bankItem) < cost)) continue;
            return false;
        }
        if (!(moneyCost == 0.0 || economy != null && economy.getBalance((OfflinePlayer)player) >= moneyCost)) {
            player.sendMessage(StringUtils.color(IridiumSkyblock.getInstance().getMessages().cannotAfford.replace("%prefix%", IridiumSkyblock.getInstance().getConfiguration().prefix)));
            return false;
        }
        return true;
    }

    private void purchase(Player player, Biomes.BiomeItem biomeItem) {
        double moneyCost = biomeItem.buyCost.money;
        IridiumSkyblock.getInstance().getEconomy().withdrawPlayer((OfflinePlayer)player, moneyCost);
        for (String bankItem : biomeItem.buyCost.bankItems.keySet()) {
            double cost = biomeItem.buyCost.bankItems.get(bankItem);
            this.setBankBalance(player, bankItem, this.getBankBalance(player, bankItem) - cost);
        }
    }

    public String formatPrice(double value) {
        if (IridiumSkyblock.getInstance().getBiomes().abbreviatePrices) {
            return IridiumSkyblock.getInstance().getConfiguration().numberFormatter.format(value);
        }
        return String.valueOf(value);
    }
}

