/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.schematics;

import com.iridium.iridiumskyblock.dependencies.jnbt.ByteArrayTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.CompoundTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.IntTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.ListTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.NBTInputStream;
import com.iridium.iridiumskyblock.dependencies.jnbt.ShortTag;
import com.iridium.iridiumskyblock.dependencies.jnbt.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SchematicData {
    public final short width;
    public final short length;
    public final short height;
    public List<Tag> tileEntities;
    public byte[] blockdata;
    public Map<String, Tag> palette;
    public Integer version;

    public static SchematicData loadSchematic(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        NBTInputStream nbtStream = new NBTInputStream(stream);
        CompoundTag schematicTag = (CompoundTag)nbtStream.readTag();
        stream.close();
        nbtStream.close();
        Object schematic = schematicTag.getValue();
        short width = SchematicData.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue();
        short length = SchematicData.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue();
        short height = SchematicData.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue();
        int version = SchematicData.getChildTag((Map<String, Tag>)schematic, "Version", IntTag.class).getValue();
        Object palette = SchematicData.getChildTag((Map<String, Tag>)schematic, "Palette", CompoundTag.class).getValue();
        byte[] blockdata = SchematicData.getChildTag((Map<String, Tag>)schematic, "BlockData", ByteArrayTag.class).getValue();
        if (version == 1) {
            Object tileEntities = SchematicData.getChildTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class).getValue();
            return new SchematicData(width, length, height, (List<Tag>)tileEntities, blockdata, (Map<String, Tag>)palette, version);
        }
        if (version == 2) {
            Object BlockEntities = SchematicData.getChildTag((Map<String, Tag>)schematic, "BlockEntities", ListTag.class).getValue();
            return new SchematicData(width, length, height, (List<Tag>)BlockEntities, blockdata, (Map<String, Tag>)palette, version);
        }
        return new SchematicData(width, length, height, Collections.emptyList(), blockdata, (Map<String, Tag>)palette, version);
    }

    public static <T extends Tag> T getChildTag(Map<String, Tag> items, String key, Class<T> expected) throws IllegalArgumentException {
        if (!items.containsKey(key)) {
            throw new IllegalArgumentException("Schematic file is missing a \"" + key + "\" tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new IllegalArgumentException(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    @Generated
    public SchematicData(short width, short length, short height, List<Tag> tileEntities, byte[] blockdata, Map<String, Tag> palette, Integer version) {
        this.width = width;
        this.length = length;
        this.height = height;
        this.tileEntities = tileEntities;
        this.blockdata = blockdata;
        this.palette = palette;
        this.version = version;
    }
}

