/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumskyblock.utils;

import com.iridium.iridiumskyblock.IridiumSkyblock;
import com.iridium.iridiumskyblock.database.Island;
import com.iridium.iridiumskyblock.dependencies.iridiumcore.multiversion.MultiVersion;
import com.iridium.iridiumskyblock.dependencies.xseries.XMaterial;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class LocationUtils {
    private static final List<Material> unsafeBlocks = Stream.of(XMaterial.END_PORTAL, XMaterial.WATER, XMaterial.LAVA).map(XMaterial::parseMaterial).collect(Collectors.toList());

    public static boolean isSafe(Location location) {
        if (IridiumSkyblock.isTesting()) {
            return true;
        }
        Block block = location.getBlock();
        Block above = location.clone().add(0.0, 1.0, 0.0).getBlock();
        Block below = location.clone().subtract(0.0, 1.0, 0.0).getBlock();
        MultiVersion multiVersion = IridiumSkyblock.getInstance().getMultiVersion();
        return multiVersion.isPassable(block) && multiVersion.isPassable(above) && !multiVersion.isPassable(below) && !unsafeBlocks.contains(below.getType()) && !unsafeBlocks.contains(block.getType()) && !unsafeBlocks.contains(above.getType());
    }

    @Nullable
    public static Location getSafeLocation(Location location, Island island) {
        World world = location.getWorld();
        if (world == null) {
            return location;
        }
        if (island == null) {
            return location;
        }
        if (LocationUtils.isSafe(location)) {
            return location;
        }
        Location highest = LocationUtils.getHighestLocation(location.getBlockX(), location.getBlockZ(), world);
        if (LocationUtils.isSafe(highest)) {
            return highest;
        }
        Location pos1 = island.getPosition1(world);
        Location pos2 = island.getPosition2(world);
        for (int x = pos1.getBlockX(); x <= pos2.getBlockX(); ++x) {
            for (int z = pos1.getBlockZ(); z <= pos2.getBlockZ(); ++z) {
                Location newLocation = LocationUtils.getHighestLocation(x, z, world);
                if (!LocationUtils.isSafe(newLocation)) continue;
                return newLocation;
            }
        }
        return null;
    }

    private static Location getHighestLocation(int x, int z, World world) {
        Block block = world.getHighestBlockAt(x, z);
        while (!IridiumSkyblock.getInstance().getMultiVersion().isPassable(block)) {
            block = block.getLocation().add(0.0, 1.0, 0.0).getBlock();
        }
        return block.getLocation().add(0.5, 0.0, 0.5);
    }

    public static int getMinHeight(World world) {
        return XMaterial.getVersion() >= 17 ? world.getMinHeight() : 0;
    }
}

