/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.utils;

public class TimeUtils {
    private static final int TICKS_PER_SECOND = 20;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;

    public static String formatTicks(long ticks) {
        long totalSeconds = ticks / 20L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static String formatTicksLong(long ticks) {
        long totalSeconds = ticks / 20L;
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static String formatTicksCompact(long ticks) {
        long totalSeconds = ticks / 20L;
        if (totalSeconds >= 3600L) {
            return TimeUtils.formatTicksLong(ticks);
        }
        return TimeUtils.formatTicks(ticks);
    }

    public static long ticksToSeconds(long ticks) {
        return ticks / 20L;
    }

    public static long secondsToTicks(long seconds) {
        return seconds * 20L;
    }

    public static long minutesToTicks(long minutes) {
        return minutes * 60L * 20L;
    }
}

