/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.server.IntegratedServer;

public class WorldIconUpdateEvent {
    public static void onRenderLevelStage() {
        IntegratedServer server;
        if (!BetterClient.config.enableWorldIconUpdate) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.isLocalServer() && (server = minecraft.getSingleplayerServer()) != null && !server.isStopped()) {
            server.getWorldScreenshotFile().ifPresent(WorldIconUpdateEvent::captureCleanScreenshot);
        }
    }

    private static void captureCleanScreenshot(Path path) {
        Screenshot.takeScreenshot((RenderTarget)Minecraft.getInstance().getMainRenderTarget(), nativeImage -> Util.ioPool().execute(() -> {
            int i = nativeImage.getWidth();
            int j = nativeImage.getHeight();
            int k = 0;
            int l = 0;
            if (i > j) {
                k = (i - j) / 2;
                i = j;
            } else {
                l = (j - i) / 2;
                j = i;
            }
            try (NativeImage nativeImage2 = new NativeImage(64, 64, false);){
                nativeImage.resizeSubRectTo(k, l, i, j, nativeImage2);
                nativeImage2.writeToFile(path);
            }
            catch (IOException iOException) {
                BetterClient.LOGGER.warn("Couldn't save auto screenshot", (Throwable)iOException);
            }
            finally {
                nativeImage.close();
            }
        }));
    }
}

