/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.client.events.TradingHudEvent;
import com.euphony.better_client.utils.data.MerchantInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.inventory.MenuType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class ClientPacketListenerMixin {
    @Inject(at={@At(value="HEAD")}, method={"handleMerchantOffers(Lnet/minecraft/network/protocol/game/ClientboundMerchantOffersPacket;)V"}, cancellable=true)
    public void onHandleMerchantOffers(ClientboundMerchantOffersPacket packet, CallbackInfo ci) {
        if (!BetterClient.config.enableTradingHud) {
            return;
        }
        MerchantInfo.getInstance().setOffers(packet.getOffers());
        if (!TradingHudEvent.isWindowOpen()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleOpenScreen(Lnet/minecraft/network/protocol/game/ClientboundOpenScreenPacket;)V"}, cancellable=true)
    public void onHandleOpenScreen(ClientboundOpenScreenPacket packet, CallbackInfo ci) {
        if (!BetterClient.config.enableTradingHud) {
            return;
        }
        if (!TradingHudEvent.isWindowOpen() && packet.getType() == MenuType.MERCHANT) {
            ci.cancel();
            this.better_client$closeContainer(packet.getContainerId());
        }
    }

    @Unique
    private void better_client$closeContainer(int containerId) {
        if (!BetterClient.config.enableTradingHud) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null) {
            minecraft.player.connection.send((Packet)new ServerboundContainerClosePacket(containerId));
        }
    }
}

