/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.BetterClient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={WorldSelectionList.WorldListEntry.class})
public class WorldListEntryMixin {
    @Redirect(method={"getNarration()Lnet/minecraft/network/chat/Component;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelSummary;isExperimental()Z"))
    private boolean disableExperimentalWarning(LevelSummary instance) {
        if (BetterClient.config.enableNoExperimentalWarning && !BetterClient.config.enableExperimentalDisplay) {
            return false;
        }
        return instance.isExperimental();
    }

    @Redirect(method={"<init>(Lnet/minecraft/client/gui/screens/worldselection/WorldSelectionList;Lnet/minecraft/world/level/storage/LevelSummary;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelSummary;getInfo()Lnet/minecraft/network/chat/Component;"))
    private Component modifyInfo(LevelSummary levelSummary) {
        if (BetterClient.config.enableNoExperimentalWarning && !BetterClient.config.enableExperimentalDisplay) {
            if (levelSummary.info == null) {
                levelSummary.info = this.better_client$createInfo(levelSummary);
            }
            return levelSummary.info;
        }
        return levelSummary.getInfo();
    }

    @Unique
    private Component better_client$createInfo(LevelSummary levelSummary) {
        MutableComponent mutableComponent;
        if (levelSummary.isLocked()) {
            return Component.translatable((String)"selectWorld.locked").withStyle(ChatFormatting.RED);
        }
        if (levelSummary.requiresManualConversion()) {
            return Component.translatable((String)"selectWorld.conversion").withStyle(ChatFormatting.RED);
        }
        if (!levelSummary.isCompatible()) {
            return Component.translatable((String)"selectWorld.incompatible.info", (Object[])new Object[]{levelSummary.getWorldVersionName()}).withStyle(ChatFormatting.RED);
        }
        MutableComponent mutableComponent2 = mutableComponent = levelSummary.isHardcore() ? Component.empty().append((Component)Component.translatable((String)"gameMode.hardcore").withColor(-65536)) : Component.translatable((String)("gameMode." + levelSummary.getGameMode().getName()));
        if (levelSummary.hasCommands()) {
            mutableComponent.append(", ").append((Component)Component.translatable((String)"selectWorld.commands"));
        }
        MutableComponent mutableComponent22 = levelSummary.getWorldVersionName();
        MutableComponent mutableComponent3 = Component.literal((String)", ").append((Component)Component.translatable((String)"selectWorld.version")).append(CommonComponents.SPACE);
        if (levelSummary.shouldBackup()) {
            mutableComponent3.append((Component)mutableComponent22.withStyle(levelSummary.isDowngrade() ? ChatFormatting.RED : ChatFormatting.ITALIC));
        } else {
            mutableComponent3.append((Component)mutableComponent22);
        }
        mutableComponent.append((Component)mutableComponent3);
        return mutableComponent;
    }
}

