/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.config.BetterClientConfig;
import com.euphony.better_client.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.StringUtils;

public class BiomeTitleEvent {
    public static Biome previousBiome;
    public static ResourceKey<Biome> displayBiome;
    public static int displayTime;
    public static int alpha;
    public static int cooldownTime;
    public static int fadeTimer;
    public static boolean complete;
    public static boolean fadingIn;
    public static final Map<ResourceKey<Biome>, Component> NAME_CACHE;

    private BiomeTitleEvent() {
    }

    public static void clientPre(Minecraft minecraft) {
        if (complete) {
            if (!fadingIn) {
                if (displayTime > 0) {
                    --displayTime;
                } else if (fadeTimer > 0) {
                    alpha = (int)(255.0f / (float)((BetterClientConfig)BetterClientConfig.HANDLER.instance()).fadeOutTime * (float)(--fadeTimer));
                } else if (cooldownTime > 0) {
                    --cooldownTime;
                }
            } else if (fadeTimer < ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).fadeInTime) {
                alpha = (int)(255.0f / (float)((BetterClientConfig)BetterClientConfig.HANDLER.instance()).fadeInTime * (float)(++fadeTimer));
            } else {
                fadeTimer = ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).fadeOutTime;
                fadingIn = false;
                displayTime = (int)(((BetterClientConfig)BetterClientConfig.HANDLER.instance()).displayDuration * 20.0);
                alpha = 255;
            }
        }
    }

    public static void renderBiomeInfo(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (complete && ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enableBiomeTitle) {
            Minecraft mc = Minecraft.getInstance();
            if (BiomeTitleEvent.hideInF1(mc) || BiomeTitleEvent.hideInF3(mc)) {
                return;
            }
            Entity player = mc.getCameraEntity();
            if (player == null) {
                return;
            }
            BlockPos pos = player.getOnPos();
            if (mc.level != null && mc.level.isLoaded(pos)) {
                boolean shouldUpdate;
                Holder biomeHolder = mc.level.getBiome(pos);
                if (!biomeHolder.isBound()) {
                    return;
                }
                Biome biome = (Biome)biomeHolder.value();
                boolean isPlayerUnderground = mc.level.dimensionType().hasSkyLight() && !mc.level.canSeeSky(pos);
                boolean bl = shouldUpdate = ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enableUndergroundUpdate || !isPlayerUnderground;
                if (previousBiome != biome) {
                    previousBiome = biome;
                    if (cooldownTime == 0 && shouldUpdate) {
                        biomeHolder.unwrapKey().ifPresent(key -> {
                            cooldownTime = (int)(((BetterClientConfig)BetterClientConfig.HANDLER.instance()).cooldownTime * 20.0);
                            displayBiome = key;
                            displayTime = 0;
                            alpha = 0;
                            fadingIn = true;
                        });
                    }
                }
                if (alpha > 0) {
                    Font font = mc.font;
                    float scale = (float)((BetterClientConfig)BetterClientConfig.HANDLER.instance()).scale;
                    PoseStack pose = guiGraphics.pose();
                    pose.pushPose();
                    pose.translate((double)guiGraphics.guiWidth() / 2.0, (double)guiGraphics.guiHeight() / 2.0, 0.0);
                    pose.scale(scale, scale, scale);
                    Component biomeName = BiomeTitleEvent.getBiomeName(displayBiome);
                    int textWidth = font.width((FormattedText)biomeName);
                    int y = -font.wordWrapHeight(biomeName.getString(), 999) / 2 + ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).yOffset;
                    guiGraphics.drawString(font, biomeName, -textWidth / 2, y, 0xFFFFFF | alpha << 24, true);
                    pose.popPose();
                }
            }
        }
    }

    private static Component getBiomeName(ResourceKey<Biome> key) {
        String modName;
        ResourceLocation location = key.location();
        Component name = NAME_CACHE.computeIfAbsent(key, k -> {
            MutableComponent biomeName;
            String translationKey = Util.makeDescriptionId((String)"biome", (ResourceLocation)location);
            MutableComponent displayName = biomeName = Component.translatable((String)translationKey);
            String displayedText = biomeName.getString();
            if (displayedText.equals(translationKey)) {
                String biomePath = key.location().getPath();
                String formattedBiomeName = BiomeTitleEvent.snakeCaseToEnglish(biomePath);
                displayName = Component.literal((String)formattedBiomeName);
            }
            return displayName;
        });
        MutableComponent displayName = name.copy();
        if (((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enableModName && (modName = BiomeTitleEvent.getModName(location)) != null) {
            displayName = displayName.append((Component)Component.literal((String)String.format(" (%s)", modName)));
        }
        return displayName;
    }

    private static boolean hideInF1(Minecraft mc) {
        return mc.options.hideGui && ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).hideInF1;
    }

    private static boolean hideInF3(Minecraft mc) {
        return mc.getDebugOverlay().showDebugScreen() && ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).hideInF3;
    }

    private static String snakeCaseToEnglish(String biomePath) {
        String[] words = biomePath.split("_");
        StringJoiner formatted = new StringJoiner(" ");
        for (String word : words) {
            formatted.add(StringUtils.capitalize((String)word));
        }
        return formatted.toString();
    }

    private static String getModName(ResourceLocation location) {
        String modId = location.getNamespace();
        String displayName = Utils.getModDisplayName(modId);
        return displayName == null ? BiomeTitleEvent.snakeCaseToEnglish(modId) : displayName;
    }

    public static void clientLevelLoad(ClientLevel clientLevel) {
        complete = true;
    }

    static {
        displayTime = 0;
        alpha = 0;
        cooldownTime = 0;
        fadeTimer = 0;
        complete = false;
        fadingIn = false;
        NAME_CACHE = new HashMap<ResourceKey<Biome>, Component>();
    }
}

