/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.config.BetterClientConfig;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenMixin
extends Screen {
    @Shadow
    private boolean isModified;
    @Shadow
    private int currentPage;
    @Unique
    double better_client$progress = 0.0;

    @Shadow
    protected abstract void pageBack();

    @Shadow
    protected abstract void pageForward();

    @Shadow
    protected abstract int getNumPages();

    protected BookEditScreenMixin(Component component) {
        super(component);
    }

    public void onClose() {
        if (!((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enableBookSaveConfirmation) {
            super.onClose();
            return;
        }
        if (this.isModified) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(response -> {
                if (response) {
                    this.minecraft.setScreen(null);
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.translatable((String)"message.better_client.book_save.title"), (Component)Component.translatable((String)"message.better_client.book_save.question")));
        } else {
            super.onClose();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enableBookScroll) {
            return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        double scrollDelta = verticalAmount + horizontalAmount;
        double better_client$speedFactor = 1.0;
        if (BookEditScreenMixin.hasControlDown()) {
            better_client$speedFactor *= (double)((BetterClientConfig)BetterClientConfig.HANDLER.instance()).ctrlSpeedMultiplier;
        }
        this.better_client$progress += scrollDelta * better_client$speedFactor;
        boolean pageTurned = false;
        if (this.better_client$progress >= 1.0) {
            while (this.better_client$progress >= 1.0) {
                this.better_client$progress -= 1.0;
                this.pageBack();
                pageTurned = true;
            }
        } else if (this.better_client$progress < 0.0) {
            while (this.better_client$progress < 0.0) {
                this.better_client$progress += 1.0;
                if (this.currentPage < this.getNumPages() - 1) {
                    this.pageForward();
                }
                pageTurned = true;
            }
        }
        if (pageTurned && ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enablePageTurnSound) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }
}

