/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.screen.widget.FastTradingButton;
import com.euphony.better_client.utils.ItemUtils;
import com.euphony.better_client.utils.KeyUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantScreen.class})
public abstract class MerchantScreenMixin
extends AbstractContainerScreen<MerchantMenu> {
    @Shadow
    private int shopItem;
    @Unique
    private int better_client$tradeState = 0;
    @Unique
    private FastTradingButton better_client$fastTradingButton;
    @Unique
    private final Map<Integer, Component> better_client$tradeDescriptionCache = new HashMap<Integer, Component>();
    @Unique
    private int better_client$lastCachedShopItem = -1;

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    public void addSpeedTradeButton(CallbackInfo ci) {
        if (!BetterClient.config.enableFastTrading) {
            return;
        }
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.better_client$fastTradingButton = new FastTradingButton(i + 247, j + 37, 18, 18, button -> {
            ((MerchantMenu)this.menu).setSelectionHint(this.shopItem);
            if (this.minecraft != null) {
                this.minecraft.getConnection().send((Packet)new ServerboundSelectTradePacket(this.shopItem));
            }
            this.better_client$tradeState = 1;
        });
        this.addRenderableWidget((GuiEventListener)this.better_client$fastTradingButton);
    }

    protected void containerTick() {
        super.containerTick();
        this.better_client$fastTradingButton.active = false;
        if (!BetterClient.config.enableFastTrading) {
            return;
        }
        if (this.minecraft != null && this.minecraft.player != null) {
            Component tradeDescription;
            Inventory inventory = this.minecraft.player.getInventory();
            MerchantOffer merchantOffer = (MerchantOffer)((MerchantMenu)this.menu).getOffers().get(this.shopItem);
            if (merchantOffer.getUses() == merchantOffer.getMaxUses()) {
                this.better_client$fastTradingButton.active = false;
            } else {
                boolean hasEnoughCostA;
                ItemStack costA = merchantOffer.getCostA();
                ItemStack costB = merchantOffer.getCostB();
                ItemStack sellItem = merchantOffer.getResult();
                ItemStack slotA = ((Slot)((MerchantMenu)this.menu).slots.get(0)).getItem();
                ItemStack slotB = ((Slot)((MerchantMenu)this.menu).slots.get(1)).getItem();
                int costACount = this.better_client$getItemTotalCountWithSlots(inventory, costA, slotA, slotB);
                boolean bl = hasEnoughCostA = costACount >= costA.getCount() && costA.getCount() > 0;
                if (!this.better_client$isInactiveAlt(sellItem)) {
                    if (!merchantOffer.getCostB().isEmpty()) {
                        int costBCount = this.better_client$getItemTotalCountWithSlots(inventory, costB, slotA, slotB);
                        boolean hasEnoughCostB = costBCount >= costB.getCount() && costB.getCount() > 0;
                        this.better_client$fastTradingButton.active = hasEnoughCostA && hasEnoughCostB;
                    } else {
                        this.better_client$fastTradingButton.active = hasEnoughCostA;
                    }
                }
            }
            if (this.better_client$lastCachedShopItem == this.shopItem && this.better_client$tradeDescriptionCache.containsKey(this.shopItem)) {
                tradeDescription = this.better_client$tradeDescriptionCache.get(this.shopItem);
            } else {
                tradeDescription = this.better_client$generateTradeDescription(merchantOffer);
                this.better_client$tradeDescriptionCache.put(this.shopItem, tradeDescription);
                this.better_client$lastCachedShopItem = this.shopItem;
            }
            this.better_client$fastTradingButton.setTooltip(Tooltip.create((Component)tradeDescription));
            if (this.better_client$tradeState > 0) {
                MerchantOffer offer = (MerchantOffer)((MerchantMenu)this.menu).getOffers().get(this.shopItem);
                switch (this.better_client$tradeState) {
                    case 1: {
                        ItemStack item = offer.getItemCostA().itemStack();
                        if (!item.isEmpty()) {
                            this.better_client$fillSlots(item);
                        }
                        offer.getItemCostB().ifPresent(cost -> this.better_client$fillSlots(cost.itemStack()));
                        this.better_client$tradeState = 2;
                        break;
                    }
                    case 2: {
                        if (!((MerchantMenu)this.menu).getSlot(2).getItem().isEmpty()) {
                            this.slotClicked(((MerchantMenu)this.menu).getSlot(2), 2, 0, ClickType.QUICK_MOVE);
                            this.better_client$tradeState = 3;
                            break;
                        }
                        this.better_client$tradeState = 0;
                        break;
                    }
                    case 3: {
                        if (offer.getUses() < offer.getMaxUses() && inventory.getFreeSlot() != -1) {
                            this.better_client$tradeState = 1;
                            break;
                        }
                        this.better_client$tradeState = 4;
                        break;
                    }
                    case 4: {
                        this.slotClicked(((MerchantMenu)this.menu).getSlot(0), 0, 0, ClickType.QUICK_MOVE);
                        this.slotClicked(((MerchantMenu)this.menu).getSlot(1), 1, 0, ClickType.QUICK_MOVE);
                        this.better_client$tradeState = 0;
                    }
                }
            }
        }
    }

    @Unique
    private void better_client$fillSlots(ItemStack item) {
        int count = 0;
        for (int i = 3; i < 39; ++i) {
            ItemStack invstack = ((MerchantMenu)this.menu).getSlot(i).getItem();
            if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)invstack)) continue;
            this.slotClicked(((MerchantMenu)this.menu).getSlot(i), i, i, ClickType.PICKUP);
            this.slotClicked(((MerchantMenu)this.menu).getSlot(0), 0, 0, ClickType.PICKUP_ALL);
            if ((count += invstack.getCount()) > ((MerchantMenu)this.menu).getSlot(i).getItem().getMaxStackSize()) {
                this.slotClicked(((MerchantMenu)this.menu).getSlot(i), i, i, ClickType.PICKUP);
                break;
            }
            if (count == ((MerchantMenu)this.menu).getSlot(i).getItem().getMaxStackSize()) break;
        }
    }

    @Unique
    private Component better_client$generateTradeDescription(MerchantOffer offer) {
        ItemStack costA = offer.getCostA();
        ItemStack costB = offer.getCostB();
        ItemStack sellItem = offer.getResult();
        MutableComponent component = Component.empty();
        if (this.better_client$isInactiveAlt(sellItem)) {
            component.append((Component)Component.translatable((String)"message.better_client.fast_trading.alt").withStyle(ChatFormatting.RED));
        }
        component.append(ItemUtils.getWrappedItemName(costA));
        if (!costB.isEmpty()) {
            component.append((Component)ItemUtils.createTooltip(" + ", new Object[0]));
            component.append(ItemUtils.getWrappedItemName(costB));
        }
        component.append((Component)ItemUtils.createTooltip(" -> ", new Object[0]));
        component.append(ItemUtils.getWrappedItemName(sellItem));
        return component;
    }

    @Unique
    private int better_client$getItemTotalCountWithSlots(Inventory inventory, ItemStack itemStack, ItemStack ... slots) {
        int count = ItemUtils.getItemTotalCount(inventory, itemStack);
        for (ItemStack slot : slots) {
            if (slot == null || slot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)slot)) continue;
            count += slot.getCount();
        }
        return count;
    }

    @Unique
    private boolean better_client$isInactiveAlt(ItemStack sellItem) {
        return BetterClient.config.enableAltKey && !KeyUtils.hasAltDown() && (sellItem.isDamageableItem() || !sellItem.isStackable());
    }

    @Shadow
    protected abstract void renderButtonArrows(GuiGraphics var1, MerchantOffer var2, int var3, int var4);

    public MerchantScreenMixin(MerchantMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Inject(method={"renderButtonArrows(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/trading/MerchantOffer;II)V"}, at={@At(value="TAIL")})
    private void injectRenderButtonArrows(GuiGraphics guiGraphics, MerchantOffer merchantOffer, int i, int j, CallbackInfo ci) {
        if (BetterClient.config.enableDisplayRemainingSales) {
            int remainingUses = merchantOffer.getMaxUses() - merchantOffer.getUses();
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)(i + 61), (float)(j + 11));
            guiGraphics.pose().scale(0.6f, 0.6f);
            guiGraphics.drawString(this.font, String.valueOf(remainingUses), 0, 0, -1, false);
            guiGraphics.pose().popMatrix();
        }
    }
}

