/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.keymapping.BCKeyMappings;
import com.euphony.better_client.utils.records.BundleCandidate;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BundleUpEvent {
    public static void bundleUp(Minecraft minecraft, Screen screen, KeyEvent keyEvent) {
        if (!BCKeyMappings.BUNDLE_UP.matches(keyEvent) || !BetterClient.config.enableBundleUp) {
            return;
        }
        ArrayList<BundleCandidate> candidates = new ArrayList<BundleCandidate>();
        LocalPlayer player = minecraft.player;
        if (player == null || screen == null) {
            return;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (containerScreen.hoveredSlot == null) {
                return;
            }
            Slot hoveredSlot = containerScreen.hoveredSlot;
            ItemStack selectedItem = hoveredSlot.getItem();
            if (!selectedItem.is(ItemTags.BUNDLES)) {
                return;
            }
            AbstractContainerMenu abstractContainerMenu = containerScreen.getMenu();
            if (abstractContainerMenu instanceof ChestMenu) {
                ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
                for (int i = 0; i < chestMenu.slots.size(); ++i) {
                    Container container;
                    Slot slot = chestMenu.getSlot(i);
                    ItemStack stack = slot.getItem();
                    if (stack.isEmpty() || (container = slot.container) instanceof Inventory && slot.slot >= 9) continue;
                    double efficiency = (double)stack.getMaxStackSize() / (double)stack.getCount();
                    candidates.add(new BundleCandidate(slot, i, stack, efficiency));
                }
            } else if (containerScreen instanceof InventoryScreen || containerScreen instanceof CreativeModeInventoryScreen) {
                AbstractContainerMenu menu = containerScreen.getMenu();
                for (int i = 0; i < menu.slots.size(); ++i) {
                    Container container;
                    Slot slot = menu.getSlot(i);
                    ItemStack stack = slot.getItem();
                    if (stack.isEmpty() || !((container = slot.container) instanceof Inventory) || slot.slot < 9) continue;
                    double efficiency = (double)stack.getMaxStackSize() / (double)stack.getCount();
                    candidates.add(new BundleCandidate(slot, i, stack, efficiency));
                }
            }
            candidates.sort(null);
            for (BundleCandidate candidate : candidates) {
                BundleUpEvent.performSlotSwap(containerScreen, hoveredSlot, candidate.slot(), (Player)player);
            }
        }
    }

    public static void performSlotSwap(AbstractContainerScreen<?> screen, Slot bundleSlot, Slot targetSlot, Player player) {
        screen.slotClicked(bundleSlot, 1, 0, ClickType.PICKUP);
        screen.slotClicked(targetSlot, 0, 0, ClickType.PICKUP);
        if (!player.containerMenu.getCarried().isEmpty()) {
            screen.slotClicked(bundleSlot, 1, 0, ClickType.PICKUP);
        }
    }
}

