/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FasterClimbingEvent {
    public static void playerPre(Player player) {
        if (!player.level().isClientSide() || !BetterClient.config.enableFasterClimbing) {
            return;
        }
        if (player.onClimbable() && !player.isCrouching()) {
            Climber climber = new Climber(player);
            if (BetterClient.config.enableFasterDownward && climber.isFacingDownward() && !climber.isMovingForward() && !climber.isMovingBackward()) {
                climber.moveDownFaster();
            } else if (BetterClient.config.enableFasterUpward && climber.isFacingUpward() && climber.isMovingForward()) {
                climber.moveUpFaster();
            }
        }
    }

    private record Climber(Player player) {
        private boolean isFacingDownward() {
            return this.player.getXRot() > 0.0f;
        }

        private boolean isFacingUpward() {
            return this.player.getXRot() < 0.0f;
        }

        private boolean isMovingForward() {
            return this.player.zza > 0.0f;
        }

        private boolean isMovingBackward() {
            return this.player.zza < 0.0f;
        }

        private float getSpeed() {
            return (float)(Math.sin(Math.abs((double)this.player.getXRot() * Math.PI / 180.0)) * BetterClient.config.speedMultiplier / 10.0);
        }

        public void moveUpFaster() {
            float dy = this.getSpeed();
            Vec3 move = new Vec3(0.0, (double)dy, 0.0);
            this.player.move(MoverType.SELF, move);
        }

        public void moveDownFaster() {
            float dy = -this.getSpeed();
            Vec3 move = new Vec3(0.0, (double)dy, 0.0);
            this.player.move(MoverType.SELF, move);
        }
    }
}

