/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.config.BetterClientConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BookViewScreen.class})
public abstract class BookViewScreenMixin
extends Screen {
    @Shadow
    private int currentPage;
    @Unique
    double better_client$progress = 0.0;

    @Shadow
    protected abstract void pageBack();

    @Shadow
    protected abstract int getNumPages();

    @Shadow
    protected abstract void pageForward();

    protected BookViewScreenMixin(Component component) {
        super(component);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enableBookScroll) {
            return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        double scrollDelta = verticalAmount + horizontalAmount;
        double better_client$speedFactor = 1.0;
        if (BookViewScreenMixin.hasControlDown()) {
            better_client$speedFactor *= (double)((BetterClientConfig)BetterClientConfig.HANDLER.instance()).ctrlSpeedMultiplier;
        }
        this.better_client$progress += scrollDelta * better_client$speedFactor;
        boolean pageTurned = false;
        if (this.better_client$progress >= 1.0) {
            while (this.better_client$progress >= 1.0) {
                this.better_client$progress -= 1.0;
                this.pageBack();
                pageTurned = true;
            }
        } else if (this.better_client$progress < 0.0) {
            while (this.better_client$progress < 0.0) {
                this.better_client$progress += 1.0;
                if (this.currentPage < this.getNumPages() - 1) {
                    this.pageForward();
                }
                pageTurned = true;
            }
        }
        if (pageTurned && ((BetterClientConfig)BetterClientConfig.HANDLER.instance()).enablePageTurnSound) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }
}

