/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.utils;

import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public final class ItemUtils {
    private ItemUtils() {
    }

    public static MutableComponent createTooltip(String key, Object ... objects) {
        return Component.translatable((String)key, (Object[])objects).withStyle(ChatFormatting.GRAY);
    }

    public static int getItemTotalCount(Inventory inventory, ItemStack itemStack) {
        int count = 0;
        for (int i = 0; i < inventory.getNonEquipmentItems().size(); ++i) {
            ItemStack itemStack1 = (ItemStack)inventory.getNonEquipmentItems().get(i);
            if (itemStack1.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)itemStack1)) continue;
            count += itemStack1.getCount();
        }
        return count;
    }

    public static Component getWrappedItemName(ItemStack stack) {
        MutableComponent mutableComponent = Component.empty().append(stack.getHoverName());
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            mutableComponent.withStyle(ChatFormatting.ITALIC);
        }
        mutableComponent.withStyle(stack.getRarity().color());
        return ItemUtils.createTooltip("[", new Object[0]).append((Component)mutableComponent).append((Component)ItemUtils.createTooltip("] x", new Object[0])).append((Component)ItemUtils.createTooltip(String.valueOf(stack.getCount()), new Object[0]));
    }
}

