/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.config.screen.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CategoryButton
extends Button {
    private final ItemStack icon;
    private final Component text;
    private static final int MARGIN = 8;
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));

    public CategoryButton(int x, int y, int w, int h, Component text, ItemStack icon, Button.OnPress onClick) {
        super(x, y, w, h, text, onClick, DEFAULT_NARRATION);
        this.icon = icon;
        this.text = text;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.renderFakeItem(this.icon, this.getX() + 5, this.getY() + 2);
        guiGraphics.drawCenteredString(mc.font, this.text, this.getX() + this.width / 2 + 8, this.getY() + (this.height - 8) / 2, -1);
    }
}

