/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.utils;

import com.euphony.better_client.utils.Utils;
import java.util.StringJoiner;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.StringUtils;

public class BiomeUtils {
    private BiomeUtils() {
    }

    public static String snakeCaseToTitle(String snakeCaseText) {
        String[] words = snakeCaseText.split("_");
        StringJoiner formatted = new StringJoiner(" ");
        for (String word : words) {
            formatted.add(StringUtils.capitalize((String)word));
        }
        return formatted.toString();
    }

    public static String getModDisplayName(ResourceLocation location) {
        String modId = location.getNamespace();
        String displayName = Utils.getModDisplayName(modId);
        return displayName != null ? displayName : BiomeUtils.snakeCaseToTitle(modId);
    }

    public static Component createBiomeDisplayComponent(ResourceKey<Biome> key, boolean enableModName) {
        ResourceLocation location = key.location();
        String translationKey = Util.makeDescriptionId((String)"biome", (ResourceLocation)location);
        MutableComponent biomeName = Component.translatable((String)translationKey);
        String displayedText = biomeName.getString();
        if (displayedText.equals(translationKey)) {
            String biomePath = location.getPath();
            biomeName = Component.literal((String)BiomeUtils.snakeCaseToTitle(biomePath));
        }
        if (enableModName) {
            String modName = BiomeUtils.getModDisplayName(location);
            biomeName = biomeName.append((Component)Component.literal((String)String.format(" (%s)", modName)));
        }
        return biomeName;
    }
}

