/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.utils.data;

import java.util.Optional;
import net.minecraft.world.item.trading.MerchantOffers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MerchantInfo {
    private static final MerchantInfo INSTANCE = new MerchantInfo();
    @Nullable
    private Integer lastEntityId;
    @NotNull
    private MerchantOffers offers = new MerchantOffers();

    private MerchantInfo() {
    }

    public static MerchantInfo getInstance() {
        return INSTANCE;
    }

    @NotNull
    public MerchantOffers getOffers() {
        return this.offers;
    }

    public void setOffers(@NotNull MerchantOffers offers) {
        this.offers = offers;
    }

    public Optional<Integer> getLastEntityId() {
        return Optional.ofNullable(this.lastEntityId);
    }

    public void setLastEntityId(@Nullable Integer entityId) {
        this.lastEntityId = entityId;
    }

    public boolean isSameEntity(int entityId) {
        return this.getLastEntityId().map(id -> id == entityId).orElse(false);
    }

    public void reset() {
        this.lastEntityId = null;
        this.offers = new MerchantOffers();
    }
}

