/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.multiplayer.PlayerInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PlayerTabOverlay.class})
public abstract class PlayerTabOverlayMixin {
    @Unique
    @Final
    private static final int PLAYER_SLOT_EXTRA_WIDTH = 45;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private static final int PING_TEXT_RENDER_OFFSET = -13;

    @ModifyConstant(method={"render(Lnet/minecraft/client/gui/GuiGraphics;ILnet/minecraft/world/scores/Scoreboard;Lnet/minecraft/world/scores/Objective;)V"}, constant={@Constant(intValue=13)})
    private int modifySlotWidthConstant(int original) {
        return original + 45;
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;ILnet/minecraft/world/scores/Scoreboard;Lnet/minecraft/world/scores/Objective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/PlayerTabOverlay;renderPingIcon(Lnet/minecraft/client/gui/GuiGraphics;IIILnet/minecraft/client/multiplayer/PlayerInfo;)V"))
    private void redirectRenderPingIcon(PlayerTabOverlay overlay, GuiGraphics graphics, int width, int x, int y, PlayerInfo player) {
        if (BetterClient.config.enableBetterPingDisplay) {
            PlayerTabOverlayMixin.better_client$render(this.minecraft, overlay, graphics, width, x, y, player);
        } else {
            overlay.renderPingIcon(graphics, width, x, y, player);
        }
    }

    @Unique
    private static void better_client$render(Minecraft mc, PlayerTabOverlay overlay, GuiGraphics graphics, int width, int x, int y, PlayerInfo player) {
        String pingString = String.format("%dms", player.getLatency());
        int pingStringWidth = mc.font.width(pingString);
        int pingTextColor = ColorUtils.getPingTextColor(player.getLatency());
        int textX = width + x - pingStringWidth - 1;
        if (BetterClient.config.enableDefaultPingBars) {
            textX -= 13;
        }
        graphics.drawString(mc.font, pingString, textX, y, pingTextColor);
        if (BetterClient.config.enableDefaultPingBars) {
            overlay.renderPingIcon(graphics, width, x, y, player);
        }
    }
}

