/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.service;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.records.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TimerHandler {
    private static final Map<ResourceKey<Level>, Map<BlockPos, Timer>> timers = new ConcurrentHashMap<ResourceKey<Level>, Map<BlockPos, Timer>>();

    public static boolean shouldReset(TrialSpawnerState state) {
        return state != TrialSpawnerState.COOLDOWN && state != TrialSpawnerState.EJECTING_REWARD;
    }

    public static boolean shouldCreate(TrialSpawnerState state) {
        return state == TrialSpawnerState.COOLDOWN || state == TrialSpawnerState.EJECTING_REWARD;
    }

    public static boolean hasTimer(Level level, BlockPos pos) {
        return TimerHandler.getTimer(level, pos) != null;
    }

    public static void insertTimer(Level level, BlockPos pos, long startTime, long cooldownTicks) {
        if (level == null || pos == null) {
            BetterClient.LOGGER.warn("\u5c1d\u8bd5\u63d2\u5165\u8ba1\u65f6\u5668\u65f6\u4f20\u5165 null \u53c2\u6570");
            return;
        }
        ResourceKey dimension = level.dimension();
        Map levelTimers = timers.computeIfAbsent((ResourceKey<Level>)dimension, k -> new ConcurrentHashMap());
        Timer timer = new Timer(startTime, cooldownTicks);
        levelTimers.put(pos.immutable(), timer);
        BetterClient.LOGGER.debug("\u4e3a\u4f4d\u7f6e {} \u521b\u5efa\u8ba1\u65f6\u5668\uff0c\u51b7\u5374\u65f6\u957f: {} ticks", (Object)pos, (Object)cooldownTicks);
    }

    public static Timer getTimer(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return null;
        }
        Map<BlockPos, Timer> levelTimers = timers.get(level.dimension());
        if (levelTimers == null) {
            return null;
        }
        return levelTimers.get(pos);
    }

    public static void deleteTimer(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return;
        }
        ResourceKey dimension = level.dimension();
        Map<BlockPos, Timer> levelTimers = timers.get(dimension);
        if (levelTimers == null) {
            return;
        }
        Timer removedTimer = levelTimers.remove(pos);
        if (removedTimer != null) {
            BetterClient.LOGGER.debug("\u5220\u9664\u4f4d\u7f6e {} \u7684\u8ba1\u65f6\u5668\uff0c\u5269\u4f59\u65f6\u95f4: {} ticks", (Object)pos, (Object)removedTimer.getRemainingTicks(level.getGameTime()));
        }
        if (levelTimers.isEmpty()) {
            timers.remove(dimension);
        }
    }

    public static void cleanupExpiredTimers(Level level) {
        if (level == null) {
            return;
        }
        Map<BlockPos, Timer> levelTimers = timers.get(level.dimension());
        if (levelTimers == null) {
            return;
        }
        long currentTime = level.getGameTime();
        levelTimers.entrySet().removeIf(entry -> {
            boolean expired = ((Timer)entry.getValue()).isExpired(currentTime);
            if (expired) {
                BetterClient.LOGGER.debug("\u6e05\u7406\u8fc7\u671f\u8ba1\u65f6\u5668: {}", entry.getKey());
            }
            return expired;
        });
        if (levelTimers.isEmpty()) {
            timers.remove(level.dimension());
        }
    }

    public static void clearDimension(ResourceKey<Level> dimension) {
        timers.remove(dimension);
        BetterClient.LOGGER.debug("\u6e05\u7406\u7ef4\u5ea6 {} \u7684\u6240\u6709\u8ba1\u65f6\u5668", dimension);
    }

    public static void clearAll() {
        timers.clear();
        BetterClient.LOGGER.debug("\u6e05\u7406\u6240\u6709\u8ba1\u65f6\u5668");
    }

    public static void onSpawnerBlockUpdate(Level level, BlockPos pos, BlockState blockState) {
        if (!BetterClient.config.enableTrialSpawnerTimer) {
            return;
        }
        try {
            TrialSpawnerState spawnerState = (TrialSpawnerState)blockState.getValue((Property)TrialSpawnerBlock.STATE);
            TimerHandler.onSpawnerStateUpdate(level, pos, spawnerState);
        }
        catch (Exception e) {
            BetterClient.LOGGER.error("\u5904\u7406\u5237\u602a\u7b3c\u65b9\u5757\u66f4\u65b0\u65f6\u51fa\u9519: {}", (Object)pos, (Object)e);
        }
    }

    public static void onSpawnerStateUpdate(Level level, BlockPos pos, TrialSpawnerState state) {
        if (!BetterClient.config.enableTrialSpawnerTimer || level == null || pos == null || state == null) {
            return;
        }
        try {
            if (TimerHandler.shouldCreate(state) && !TimerHandler.hasTimer(level, pos)) {
                long cooldownTicks = BetterClient.config.trialSpawnerCooldown * 20L;
                TimerHandler.insertTimer(level, pos, level.getGameTime(), cooldownTicks);
                return;
            }
            if (TimerHandler.shouldReset(state)) {
                TimerHandler.deleteTimer(level, pos);
            }
        }
        catch (Exception e) {
            BetterClient.LOGGER.error("\u5904\u7406\u5237\u602a\u7b3c\u72b6\u6001\u66f4\u65b0\u65f6\u51fa\u9519: {} -> {}", new Object[]{pos, state, e});
        }
    }

    public static int getActiveTimerCount() {
        return timers.values().stream().mapToInt(Map::size).sum();
    }

    public static int getTimerCount(ResourceKey<Level> dimension) {
        Map<BlockPos, Timer> levelTimers = timers.get(dimension);
        return levelTimers == null ? 0 : levelTimers.size();
    }
}

