/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.BiomeUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import org.joml.Matrix3x2fStack;

public class BiomeTitleEvent {
    private static final int MAX_ALPHA = 255;
    private static final int TICKS_PER_SECOND = 20;
    private static Biome previousBiome;
    private static ResourceKey<Biome> displayBiome;
    private static int displayTime;
    private static int alpha;
    private static int cooldownTime;
    private static int fadeTimer;
    private static boolean complete;
    private static boolean fadingIn;
    public static final Map<ResourceKey<Biome>, Component> NAME_CACHE;

    private BiomeTitleEvent() {
    }

    public static void clientPre(Minecraft minecraft) {
        if (!complete) {
            return;
        }
        if (fadingIn) {
            BiomeTitleEvent.handleFadeIn();
        } else {
            BiomeTitleEvent.handleDisplay();
        }
    }

    public static void renderBiomeInfo(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!BiomeTitleEvent.shouldRender()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Entity player = mc.getCameraEntity();
        if (player == null) {
            return;
        }
        BlockPos pos = player.getOnPos();
        if (mc.level == null || !mc.level.isLoaded(pos)) {
            return;
        }
        Holder biomeHolder = mc.level.getBiome(pos);
        if (!biomeHolder.isBound()) {
            return;
        }
        Biome currentBiome = (Biome)biomeHolder.value();
        if (BiomeTitleEvent.shouldUpdateBiome(currentBiome, pos, mc)) {
            BiomeTitleEvent.updateBiomeDisplay((Holder<Biome>)biomeHolder);
        }
        if (alpha > 0) {
            BiomeTitleEvent.renderBiomeTitle(guiGraphics, mc);
        }
    }

    public static void clientLevelLoad(ClientLevel clientLevel) {
        complete = true;
    }

    private static void handleFadeIn() {
        if (fadeTimer < BetterClient.config.fadeInTime) {
            alpha = BiomeTitleEvent.calculateAlpha(++fadeTimer, BetterClient.config.fadeInTime);
        } else {
            BiomeTitleEvent.completeFadeIn();
        }
    }

    private static void handleDisplay() {
        if (displayTime > 0) {
            --displayTime;
        } else if (fadeTimer > 0) {
            alpha = BiomeTitleEvent.calculateAlpha(--fadeTimer, BetterClient.config.fadeOutTime);
        } else if (cooldownTime > 0) {
            --cooldownTime;
        }
    }

    private static void completeFadeIn() {
        fadeTimer = BetterClient.config.fadeOutTime;
        fadingIn = false;
        displayTime = (int)(BetterClient.config.displayDuration * 20.0);
        alpha = 255;
    }

    private static int calculateAlpha(int timer, int maxTime) {
        return (int)(255.0f / (float)maxTime * (float)timer);
    }

    private static boolean shouldRender() {
        return complete && BetterClient.config.enableBiomeTitle;
    }

    private static boolean shouldUpdateBiome(Biome currentBiome, BlockPos pos, Minecraft mc) {
        if (previousBiome == currentBiome || cooldownTime > 0) {
            return false;
        }
        boolean isUnderground = mc.level.dimensionType().hasSkyLight() && !mc.level.canSeeSky(pos);
        return BetterClient.config.enableUndergroundUpdate || !isUnderground;
    }

    private static void updateBiomeDisplay(Holder<Biome> biomeHolder) {
        previousBiome = (Biome)biomeHolder.value();
        biomeHolder.unwrapKey().ifPresent(BiomeTitleEvent::initializeBiomeDisplay);
    }

    private static void initializeBiomeDisplay(ResourceKey<Biome> key) {
        cooldownTime = (int)(BetterClient.config.cooldownTime * 20.0);
        displayBiome = key;
        displayTime = 0;
        alpha = 0;
        fadeTimer = 0;
        fadingIn = true;
    }

    private static void renderBiomeTitle(GuiGraphics guiGraphics, Minecraft mc) {
        if (BiomeTitleEvent.shouldHideDisplay(mc)) {
            return;
        }
        Font font = mc.font;
        float scale = (float)BetterClient.config.scale;
        Matrix3x2fStack pose = guiGraphics.pose();
        pose.pushMatrix();
        pose.translate((float)((double)guiGraphics.guiWidth() / 2.0), (float)((double)guiGraphics.guiHeight() / 2.0));
        pose.scale(scale, scale);
        Component biomeName = BiomeTitleEvent.getBiomeName(displayBiome);
        int textWidth = font.width((FormattedText)biomeName);
        int y = -font.wordWrapHeight(biomeName.getString(), 999) / 2 + BetterClient.config.biomeTitleYOffset;
        guiGraphics.drawString(font, biomeName, -textWidth / 2, y, 0xFFFFFF | alpha << 24, true);
        pose.popMatrix();
    }

    private static boolean shouldHideDisplay(Minecraft mc) {
        return mc.options.hideGui && BetterClient.config.hideInF1 || mc.getDebugOverlay().showDebugScreen() && BetterClient.config.hideInF3;
    }

    private static Component getBiomeName(ResourceKey<Biome> key) {
        return NAME_CACHE.computeIfAbsent(key, k -> BiomeUtils.createBiomeDisplayComponent((ResourceKey<Biome>)k, BetterClient.config.enableModName));
    }

    static {
        displayTime = 0;
        alpha = 0;
        cooldownTime = 0;
        fadeTimer = 0;
        complete = false;
        fadingIn = false;
        NAME_CACHE = new HashMap<ResourceKey<Biome>, Component>();
    }
}

