/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import dev.architectury.event.CompoundEventResult;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class BeautifiedChatEvent {
    public static final String VANILLA_FORMAT = "(?i)^<[a-z0-9_]{3,16}>\\s.+$";

    public static CompoundEventResult<Component> chatReceived(ChatType.Bound bound, Component component) {
        Component newMessage = BeautifiedChatEvent.processMessage(component);
        if (component != newMessage) {
            return CompoundEventResult.interruptTrue((Object)newMessage);
        }
        return CompoundEventResult.pass();
    }

    public static Component processMessage(Component message) {
        if (message.getString().matches(VANILLA_FORMAT)) {
            MutableComponent output = Component.empty();
            if (BetterClient.config.enableTimeStamp) {
                ZonedDateTime now = ZonedDateTime.now();
                String shortTimestamp = now.format(DateTimeFormatter.ofPattern("'['HH:mm:ss']' "));
                String fullDateTimeText = now.format(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss")) + "\nUTC" + String.valueOf(now.getOffset());
                MutableComponent fullHoverText = Component.literal((String)fullDateTimeText);
                HoverEvent.ShowText hoverEvent = new HoverEvent.ShowText((Component)fullHoverText);
                output.append((Component)Component.literal((String)shortTimestamp).withColor(BetterClient.config.timeStampColor).withStyle(arg_0 -> BeautifiedChatEvent.lambda$processMessage$0((HoverEvent)hoverEvent, arg_0)));
            }
            output.append(message);
            return output;
        }
        return message.copy();
    }

    private static /* synthetic */ Style lambda$processMessage$0(HoverEvent hoverEvent, Style style) {
        return style.withHoverEvent(hoverEvent);
    }
}

