/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.mc.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.Level;

public class CompassTooltipEvent {
    public static void tooltip(ItemStack itemStack, List<Component> components, Item.TooltipContext context, TooltipFlag tooltipFlag) {
        if (!BetterClient.config.enableCompassTooltip) {
            return;
        }
        if (itemStack.is(Items.COMPASS)) {
            CompassTooltipEvent.getCompassTooltip(itemStack, components);
        } else if (itemStack.is(Items.RECOVERY_COMPASS) && BetterClient.config.enableRecoveryCompassTooltip) {
            CompassTooltipEvent.getRecoveryCompassTooltip(components);
        }
    }

    public static void getCompassTooltip(ItemStack itemStack, List<Component> components) {
        LodestoneTracker lodestoneTracker = (LodestoneTracker)itemStack.get(DataComponents.LODESTONE_TRACKER);
        ClientLevel level = Minecraft.getInstance().level;
        if (lodestoneTracker != null && lodestoneTracker.target().isPresent() && BetterClient.config.enableLodestoneTooltip) {
            lodestoneTracker.target().ifPresent(arg_0 -> CompassTooltipEvent.lambda$getCompassTooltip$0((Level)level, components, arg_0));
            return;
        }
        if (!BetterClient.config.enableNormalCompassTooltip) {
            return;
        }
        if (level != null && level.dimensionType().natural()) {
            GlobalPos spawnPosition = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)level.getRespawnData().pos());
            components.add((Component)ItemUtils.createTooltip("info.better_client.tooltip.compass.spawn_position", CompassTooltipEvent.getPositionComponent(spawnPosition.pos())));
        }
    }

    public static void getRecoveryCompassTooltip(List<Component> components) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        GlobalPos deathLocation = player.getLastDeathLocation().orElse(null);
        if (deathLocation == null) {
            return;
        }
        ResourceLocation location = deathLocation.dimension().location();
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && location.equals((Object)level.dimension().location())) {
            components.add((Component)ItemUtils.createTooltip("info.better_client.tooltip.recovery_compass.death_location", CompassTooltipEvent.getPositionComponent(deathLocation.pos())));
            return;
        }
        components.add((Component)ItemUtils.createTooltip("info.better_client.tooltip.recovery_compass.death_location.other_dimension", CompassTooltipEvent.getPositionComponentWithDimension(location, deathLocation.pos())));
    }

    public static Object[] getPositionComponent(BlockPos pos) {
        return new Object[]{Component.literal((String)String.valueOf(pos.getX())).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(pos.getY())).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(pos.getZ())).withStyle(ChatFormatting.WHITE)};
    }

    public static Object[] getPositionComponentWithDimension(ResourceLocation location, BlockPos pos) {
        MutableComponent dimensionName = Component.translatable((String)location.toString());
        if (location.getNamespace().equals("minecraft")) {
            dimensionName = Component.translatable((String)String.format("info.better_client.tooltip.dimension.%s", location.getPath()));
        }
        return new Object[]{dimensionName.withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(pos.getX())).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(pos.getY())).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(pos.getZ())).withStyle(ChatFormatting.WHITE)};
    }

    private static /* synthetic */ void lambda$getCompassTooltip$0(Level level, List components, GlobalPos pos) {
        ResourceLocation location = pos.dimension().location();
        if (level != null && location.equals((Object)level.dimension().location())) {
            components.add(ItemUtils.createTooltip("info.better_client.tooltip.compass.lodestone_position", CompassTooltipEvent.getPositionComponent(pos.pos())));
            return;
        }
        components.add(ItemUtils.createTooltip("info.better_client.tooltip.compass.lodestone_position.other_dimension", CompassTooltipEvent.getPositionComponentWithDimension(location, pos.pos())));
    }
}

