/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.enums.TooltipCategory;
import com.euphony.better_client.utils.mc.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class DurabilityTooltipEvent {
    public static void tooltip(ItemStack itemStack, List<Component> components, Item.TooltipContext context, TooltipFlag tooltipFlag) {
        if (!BetterClient.config.enableDurabilityTooltip) {
            return;
        }
        if ((BetterClient.config.showDurabilityWhenNotDamaged || itemStack.isDamaged()) && itemStack.isDamageableItem()) {
            int maxDurability = itemStack.getMaxDamage();
            int durability = maxDurability - itemStack.getDamageValue();
            switch (TooltipCategory.NUMBER) {
                case NUMBER: {
                    MutableComponent durabilityComponent = Component.literal((String)Integer.toString(durability)).withColor(itemStack.getItem().getBarColor(itemStack));
                    MutableComponent maxDurabilityComponent = Component.literal((String)Integer.toString(maxDurability)).withStyle(ChatFormatting.GRAY);
                    MutableComponent number = durability == maxDurability ? ItemUtils.createTooltip("info.better_client.durability_tooltip.number.full_durability", maxDurabilityComponent) : ItemUtils.createTooltip("info.better_client.durability_tooltip.number.damaged", durabilityComponent, maxDurabilityComponent);
                    if (BetterClient.config.showDurabilityHint) {
                        number = Component.translatable((String)"info.better_client.durability_tooltip.number.durability_hint", (Object[])new Object[]{number});
                    }
                    components.add((Component)number);
                }
            }
        }
    }
}

