/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.data.MerchantInfo;
import com.euphony.better_client.utils.mc.TradingUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;

public class TradingHudEvent {
    private static boolean isWindowOpen = false;

    public static void clientLevelPost(ClientLevel clientLevel) {
        if (!BetterClient.config.enableTradingHud) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (minecraft.screen != null || player == null) {
            return;
        }
        Entity tradableEntity = TradingUtils.getCrosshairTradableEntity(minecraft, isWindowOpen);
        TradingHudEvent.handleTradableEntity(tradableEntity, player);
    }

    private static void handleTradableEntity(Entity entity, LocalPlayer player) {
        MerchantInfo merchantInfo = MerchantInfo.getInstance();
        if (entity != null) {
            if (merchantInfo.isSameEntity(entity.getId())) {
                return;
            }
            merchantInfo.reset();
            merchantInfo.setLastEntityId(entity.getId());
            TradingHudEvent.sendInteractionPacket(entity, player);
        } else {
            merchantInfo.setLastEntityId(null);
        }
    }

    private static void sendInteractionPacket(Entity entity, LocalPlayer player) {
        ServerboundInteractPacket packet = ServerboundInteractPacket.createInteractionPacket((Entity)entity, (boolean)player.isShiftKeyDown(), (InteractionHand)InteractionHand.MAIN_HAND);
        player.connection.send((Packet)packet);
    }

    public static boolean isWindowOpen() {
        return isWindowOpen;
    }

    public static void setWindowOpen(boolean windowOpen) {
        isWindowOpen = windowOpen;
    }
}

