/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.screen;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.service.TimerHandler;
import com.euphony.better_client.utils.TimeUtils;
import com.euphony.better_client.utils.records.Timer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TrialSpawnerTimerRenderer {
    public static void drawTimer(Level level, BlockPos pos, PoseStack poseStack, SubmitNodeCollector nodeCollector, Camera camera) {
        if (!BetterClient.config.enableTrialSpawnerTimer) {
            return;
        }
        if (Minecraft.getInstance().player == null || level == null) {
            return;
        }
        Timer timer = TimerHandler.getTimer(level, pos);
        if (timer == null) {
            return;
        }
        long currentTime = level.getGameTime();
        long remainingTicks = timer.getRemainingTicks(currentTime);
        if (remainingTicks == 0L) {
            TimerHandler.deleteTimer(level, pos);
            return;
        }
        String timeText = TimeUtils.formatTicks(remainingTicks);
        MutableComponent text = Component.literal((String)timeText);
        int color = TrialSpawnerTimerRenderer.calculateTimerColor(timer, currentTime);
        TrialSpawnerTimerRenderer.drawTextAboveBlock((Component)text, color, poseStack, nodeCollector, camera);
    }

    private static void drawTextAboveBlock(Component text, int color, PoseStack poseStack, SubmitNodeCollector nodeCollector, Camera camera) {
        poseStack.pushPose();
        float yRot = camera.getYRot();
        float xRot = camera.getXRot();
        Quaternionf rotation = new Quaternionf();
        rotation.rotationYXZ((float)(-Math.PI) / 180 * (yRot - 180.0f), (float)Math.PI / 180 * -xRot, 0.0f);
        poseStack.mulPose((Quaternionfc)rotation);
        Matrix4f matrix4f = poseStack.last().pose();
        matrix4f.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix4f.scale(-0.025f, -0.025f, -0.025f);
        int m = Minecraft.getInstance().font.width(text.getString());
        matrix4f.translateLocal(0.5f, 1.0f, 0.5f);
        matrix4f.translate(1.0f - (float)m / 2.0f, -9.0f, 0.0f);
        nodeCollector.submitText(poseStack, 0.5f, 0.5f, text.getVisualOrderText(), BetterClient.config.enableDropShadow, TrialSpawnerTimerRenderer.getDisplayMode(), 0xF000F0, color, 0, 0);
        poseStack.popPose();
    }

    private static Font.DisplayMode getDisplayMode() {
        return BetterClient.config.timerSeenThroughWalls ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
    }

    private static int calculateTimerColor(Timer timer, long currentTime) {
        if (!BetterClient.config.enableDynamicTimerColor) {
            return BetterClient.config.timerColor;
        }
        double progress = timer.getProgress(currentTime);
        int color = progress < 0.25 ? -65536 : (progress < 0.5 ? Short.MIN_VALUE : (progress < 0.75 ? -256 : -16711936));
        return color;
    }
}

