/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.service;

import com.euphony.better_client.BetterClient;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

public class ItemFrameVisibilityManager {
    private static final ItemFrameVisibilityManager INSTANCE = new ItemFrameVisibilityManager();
    private final Map<String, Set<BlockPos>> hiddenFramesByWorld = new HashMap<String, Set<BlockPos>>();

    private ItemFrameVisibilityManager() {
        this.loadFromFile();
    }

    public static ItemFrameVisibilityManager getInstance() {
        return INSTANCE;
    }

    private String getCurrentWorldKey() {
        String server;
        Minecraft client = Minecraft.getInstance();
        ClientLevel level = client.level;
        if (level == null) {
            return "unknown";
        }
        String dimension = level.dimension().location().toString();
        if (client.hasSingleplayerServer()) {
            Path worldPath = client.getSingleplayerServer().getWorldPath(LevelResource.LEVEL_DATA_FILE).getParent().getFileName();
            server = "local:" + String.valueOf(worldPath);
        } else {
            String serverAddr = client.getCurrentServer() != null ? client.getCurrentServer().ip : "unknown_server";
            server = "remote:" + serverAddr;
        }
        return server + "_" + dimension;
    }

    public void toggleFrameVisibility(BlockPos pos) {
        String worldKey = this.getCurrentWorldKey();
        Set hiddenFrames = this.hiddenFramesByWorld.computeIfAbsent(worldKey, k -> new HashSet());
        if (hiddenFrames.contains(pos)) {
            hiddenFrames.remove(pos);
        } else {
            hiddenFrames.add(pos);
        }
        this.saveToFile();
    }

    public boolean isFrameHidden(BlockPos pos) {
        String worldKey = this.getCurrentWorldKey();
        Set<BlockPos> hiddenFrames = this.hiddenFramesByWorld.get(worldKey);
        return hiddenFrames != null && hiddenFrames.contains(pos);
    }

    public void clearCurrentWorld() {
        String worldKey = this.getCurrentWorldKey();
        this.hiddenFramesByWorld.remove(worldKey);
        this.saveToFile();
    }

    public void clearAll() {
        this.hiddenFramesByWorld.clear();
        this.saveToFile();
    }

    private void saveToFile() {
        Path savePath = ItemFrameVisibilityManager.getSavePath();
        try {
            Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
            JsonObject root = this.getJsonObject();
            try (BufferedWriter writer = Files.newBufferedWriter(savePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root, (Appendable)writer);
            }
        }
        catch (IOException e) {
            BetterClient.LOGGER.warn("[BetterClient] \u4fdd\u5b58\u5c55\u793a\u6846\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    @NotNull
    private JsonObject getJsonObject() {
        JsonObject root = new JsonObject();
        for (Map.Entry<String, Set<BlockPos>> entry : this.hiddenFramesByWorld.entrySet()) {
            JsonArray positions = new JsonArray();
            for (BlockPos pos : entry.getValue()) {
                JsonObject p = new JsonObject();
                p.addProperty("x", (Number)pos.getX());
                p.addProperty("y", (Number)pos.getY());
                p.addProperty("z", (Number)pos.getZ());
                positions.add((JsonElement)p);
            }
            root.add(entry.getKey(), (JsonElement)positions);
        }
        return root;
    }

    private void loadFromFile() {
        Path savePath = ItemFrameVisibilityManager.getSavePath();
        if (!Files.exists(savePath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(savePath, StandardCharsets.UTF_8);){
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.hiddenFramesByWorld.clear();
            for (Map.Entry entry : root.entrySet()) {
                String worldKey = (String)entry.getKey();
                JsonArray positions = ((JsonElement)entry.getValue()).getAsJsonArray();
                HashSet<BlockPos> posSet = new HashSet<BlockPos>();
                for (JsonElement elem : positions) {
                    JsonObject obj = elem.getAsJsonObject();
                    int x = obj.get("x").getAsInt();
                    int y = obj.get("y").getAsInt();
                    int z = obj.get("z").getAsInt();
                    posSet.add(new BlockPos(x, y, z));
                }
                this.hiddenFramesByWorld.put(worldKey, posSet);
            }
        }
        catch (Exception e) {
            BetterClient.LOGGER.error("[BetterClient] \u52a0\u8f7d\u5c55\u793a\u6846\u6570\u636e\u5931\u8d25: ", (Throwable)e);
        }
    }

    private static Path getSavePath() {
        Minecraft client = Minecraft.getInstance();
        return client.gameDirectory.toPath().resolve("better-client").resolve("item_frame_visibility.json");
    }
}

