/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.renderer;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.config.option.TotemBarRenderMode;
import com.euphony.better_client.utils.Utils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class TotemBarRenderer {
    private static final class_2960 TEX_FULL = Utils.prefix("textures/gui/sprites/totem.png");
    private static final class_2960 TEX_EMPTY = Utils.prefix("textures/gui/sprites/totem_empty.png");

    public static void render(class_332 ctx, class_9779 tickCounter) {
        if (!BetterClient.config.enableTotemBar) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1690.field_1842) {
            return;
        }
        if (client.field_1724.method_68878() || client.field_1724.method_7325()) {
            return;
        }
        int totInventory = client.field_1724.method_31548().method_18861(class_1802.field_8288);
        int handTotems = 0;
        if (client.field_1724.method_6047().method_31574(class_1802.field_8288)) {
            ++handTotems;
        }
        if (client.field_1724.method_6079().method_31574(class_1802.field_8288)) {
            ++handTotems;
        }
        TotemBarRenderer.drawIcons(ctx, totInventory, handTotems);
    }

    private static void drawIcons(class_332 ctx, int totInventory, int hand) {
        int iconSize = 9;
        int xSpace = -1;
        int ySpace = 1;
        int yOffset = 30;
        int xOffset = 91;
        int step = iconSize + xSpace;
        int total = Math.min(totInventory, 10);
        if (BetterClient.config.totemBarRenderMode == TotemBarRenderMode.INVENTORY_ONLY) {
            total -= hand;
        }
        if (total <= 0) {
            return;
        }
        class_310 client = class_310.method_1551();
        int sw = client.method_22683().method_4486();
        int sh = client.method_22683().method_4502();
        int rightEdge = sw / 2 + xOffset;
        int totalWidth = iconSize + (total - 1) * step;
        int x0 = rightEdge - totalWidth;
        int y = sh - yOffset - ySpace - iconSize * 2;
        y -= TotemBarRenderer.getTotemBarYOffset(client, iconSize + ySpace);
        for (int i = 0; i < total; ++i) {
            boolean isFull = switch (BetterClient.config.totemBarRenderMode) {
                default -> throw new MatchException(null, null);
                case TotemBarRenderMode.INVENTORY_ONLY -> true;
                case TotemBarRenderMode.COMBINED -> i >= total - hand;
            };
            class_2960 tex = isFull ? TEX_FULL : TEX_EMPTY;
            ctx.method_70845(tex, x0 + i * step, y, x0 + i * step + iconSize, y + iconSize, 0.0f, 1.0f, 0.0f, 1.0f);
        }
    }

    private static int getTotemBarYOffset(class_310 client, int spacing) {
        class_1309 mount;
        float hp;
        class_1297 vehicle;
        boolean airBar;
        if (client.field_1724 == null) {
            return 0;
        }
        int offset = BetterClient.config.totemBarYOffset;
        boolean bl = airBar = client.field_1724.method_5869() || client.field_1724.method_5669() < client.field_1724.method_5748();
        if (airBar) {
            offset += spacing;
        }
        if ((vehicle = client.field_1724.method_5854()) instanceof class_1309 && (hp = (mount = (class_1309)vehicle).method_6063()) > 0.0f) {
            if (hp > 20.0f) {
                int extraLines = (int)Math.ceil((hp - 20.0f) / 20.0f);
                offset += extraLines * spacing;
            }
            if (FabricLoader.getInstance().isModLoaded("bettermounthud")) {
                offset += spacing;
            }
        }
        return offset;
    }
}

