/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.screen;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.service.TimerHandler;
import com.euphony.better_client.utils.TimeUtils;
import com.euphony.better_client.utils.records.Timer;
import net.minecraft.class_11659;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TrialSpawnerTimerRenderer {
    public static void drawTimer(class_1937 level, class_2338 pos, class_4587 poseStack, class_11659 nodeCollector, class_4184 camera) {
        if (!BetterClient.config.enableTrialSpawnerTimer) {
            return;
        }
        if (class_310.method_1551().field_1724 == null || level == null) {
            return;
        }
        Timer timer = TimerHandler.getTimer(level, pos);
        if (timer == null) {
            return;
        }
        long currentTime = level.method_8510();
        long remainingTicks = timer.getRemainingTicks(currentTime);
        if (remainingTicks == 0L) {
            TimerHandler.deleteTimer(level, pos);
            return;
        }
        String timeText = TimeUtils.formatTicks(remainingTicks);
        class_5250 text = class_2561.method_43470((String)timeText);
        int color = TrialSpawnerTimerRenderer.calculateTimerColor(timer, currentTime);
        TrialSpawnerTimerRenderer.drawTextAboveBlock((class_2561)text, color, poseStack, nodeCollector, camera);
    }

    private static void drawTextAboveBlock(class_2561 text, int color, class_4587 poseStack, class_11659 nodeCollector, class_4184 camera) {
        poseStack.method_22903();
        float yRot = camera.method_19330();
        float xRot = camera.method_19329();
        Quaternionf rotation = new Quaternionf();
        rotation.rotationYXZ((float)(-Math.PI) / 180 * (yRot - 180.0f), (float)Math.PI / 180 * -xRot, 0.0f);
        poseStack.method_22907((Quaternionfc)rotation);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        matrix4f.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix4f.scale(-0.025f, -0.025f, -0.025f);
        int m = class_310.method_1551().field_1772.method_1727(text.getString());
        matrix4f.translateLocal(0.5f, 1.0f, 0.5f);
        matrix4f.translate(1.0f - (float)m / 2.0f, -9.0f, 0.0f);
        nodeCollector.method_73478(poseStack, 0.5f, 0.5f, text.method_30937(), BetterClient.config.enableDropShadow, TrialSpawnerTimerRenderer.getDisplayMode(), 0xF000F0, color, 0, 0);
        poseStack.method_22909();
    }

    private static class_327.class_6415 getDisplayMode() {
        return BetterClient.config.timerSeenThroughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
    }

    private static int calculateTimerColor(Timer timer, long currentTime) {
        if (!BetterClient.config.enableDynamicTimerColor) {
            return BetterClient.config.timerColor;
        }
        double progress = timer.getProgress(currentTime);
        int color = progress < 0.25 ? -65536 : (progress < 0.5 ? Short.MIN_VALUE : (progress < 0.75 ? -256 : -16711936));
        return color;
    }
}

