/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.config;

import com.euphony.better_client.utils.ConfigUtils;
import com.euphony.better_client.utils.DescComponent;
import com.euphony.better_client.utils.Utils;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.awt.Color;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_2561;

public class BetterClientConfig {
    public static ConfigClassHandler<BetterClientConfig> HANDLER = ConfigClassHandler.createBuilder(BetterClientConfig.class).id(Utils.prefix("config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setPath(Path.of("config", "better_client/client.json")).build()).build();
    private static final String CLIENT_CATEGORY = "client";
    private static final String FADING_NIGHT_VISION_GROUP = "fading_night_vision";
    private static final String BETTER_PING_DISPLAY_GROUP = "better_ping_display";
    private static final String BETTER_CHAT_GROUP = "better_chat";
    private static final String BIOME_TITLE_GROUP = "biome_title";
    private static final String FASTER_CLIMBING_GROUP = "faster_climbing";
    private static final String BOOK_SCROLL_GROUP = "book_scroll";
    private static final String CHAT_FORMATTER_GROUP = "chat_formatter";
    private static final String OTHER_GROUP = "other";
    @SerialEntry
    public boolean enableFadingNightVision = true;
    @SerialEntry
    public double fadingOutDuration = 3.0;
    @SerialEntry
    public boolean enableBetterPingDisplay = true;
    @SerialEntry
    public boolean enableDefaultPingBars = false;
    @SerialEntry
    public boolean enableLongerChatHistory = true;
    @SerialEntry
    public int chatMaxMessages = 4096;
    @SerialEntry
    public boolean enableTimeStamp = true;
    @SerialEntry
    public Color timeStampColor = new Color(15615743, false);
    @SerialEntry
    public boolean enableFasterClimbing = false;
    @SerialEntry
    public boolean enableFasterUpward = true;
    @SerialEntry
    public boolean enableFasterDownward = true;
    @SerialEntry
    public double speedMultiplier = 2.0;
    @SerialEntry
    public boolean enableBiomeTitle = true;
    @SerialEntry
    public boolean hideInF3 = true;
    @SerialEntry
    public boolean hideInF1 = true;
    @SerialEntry
    public double displayDuration = 1.5;
    @SerialEntry
    public int fadeInTime = 20;
    @SerialEntry
    public int fadeOutTime = 20;
    @SerialEntry
    public double scale = 2.1;
    @SerialEntry
    public int yOffset = -10;
    @SerialEntry
    public Color color = new Color(0xFFFFFF, false);
    @SerialEntry
    public double cooldownTime = 1.5;
    @SerialEntry
    public boolean enableModName = false;
    @SerialEntry
    public boolean enableUndergroundUpdate = false;
    @SerialEntry
    public boolean enableBookScroll = true;
    @SerialEntry
    public int ctrlSpeedMultiplier = 5;
    @SerialEntry
    public boolean enablePageTurnSound = true;
    @SerialEntry
    public boolean enableBeeInfo = true;
    @SerialEntry
    public boolean enableAxolotlBucketFix = true;
    @SerialEntry
    public boolean enableChatHistoryRetention = true;
    @SerialEntry
    public boolean enableBookSaveConfirmation = true;
    @SerialEntry
    public boolean enableGlowingEnderEye = true;
    @SerialEntry
    public boolean enableChatFormatter = true;
    @SerialEntry
    public String posFormat = "{x}, {y}, {z}";

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    public static YetAnotherConfigLib makeScreen() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> {
            Option enableFadingNightVisionOpt = ConfigUtils.getGenericOption("enableFadingNightVision").binding((Object)defaults.enableFadingNightVision, () -> config.enableFadingNightVision, newVal -> {
                config.enableFadingNightVision = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option fadingOutDurationOpt = ConfigUtils.getGenericOption("fadingOutDuration").binding((Object)defaults.fadingOutDuration, () -> config.fadingOutDuration, newVal -> {
                config.fadingOutDuration = newVal;
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)1.0, (Number)5.0)).step((Number)0.5)).formatValue(value -> class_2561.method_43470((String)(value + "s")))).build();
            Option enableBetterPingDisplayOpt = ConfigUtils.getGenericOption("enableBetterPingDisplay", BETTER_PING_DISPLAY_GROUP).binding((Object)defaults.enableBetterPingDisplay, () -> config.enableBetterPingDisplay, newVal -> {
                config.enableBetterPingDisplay = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableDefaultPingBarsOpt = ConfigUtils.getGenericOption("enableDefaultPingBars", "default_ping_bars").binding((Object)defaults.enableDefaultPingBars, () -> config.enableDefaultPingBars, newVal -> {
                config.enableDefaultPingBars = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableLongerChatHistoryOpt = ConfigUtils.getGenericOption("enableLongerChatHistory").binding((Object)defaults.enableLongerChatHistory, () -> config.enableLongerChatHistory, newVal -> {
                config.enableLongerChatHistory = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option chatMaxMessagesOpt = ConfigUtils.getGenericOption("chatMaxMessages").binding((Object)defaults.chatMaxMessages, () -> config.chatMaxMessages, newVal -> {
                config.chatMaxMessages = newVal;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).range((Number)100, (Number)32768)).build();
            Option enableTimeStampOpt = ConfigUtils.getGenericOption("enableTimeStamp").binding((Object)defaults.enableTimeStamp, () -> config.enableTimeStamp, newVal -> {
                config.enableTimeStamp = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option timeStampColorOpt = ConfigUtils.getGenericOption("timeStampColor").binding((Object)defaults.timeStampColor, () -> config.timeStampColor, newVal -> {
                config.timeStampColor = newVal;
            }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(false)).build();
            Option enableBiomeTitleOpt = ConfigUtils.getGenericOption("enableBiomeTitle", BIOME_TITLE_GROUP).binding((Object)defaults.enableBiomeTitle, () -> config.enableBiomeTitle, newVal -> {
                config.enableBiomeTitle = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option hideInF1Opt = ConfigUtils.getGenericOption("hideInF1").binding((Object)defaults.hideInF1, () -> config.hideInF1, newVal -> {
                config.hideInF1 = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option hideInF3Opt = ConfigUtils.getGenericOption("hideInF3").binding((Object)defaults.hideInF3, () -> config.hideInF3, newVal -> {
                config.hideInF3 = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option displayDurationOpt = ConfigUtils.getGenericOption("displayDuration").binding((Object)defaults.displayDuration, () -> config.displayDuration, newVal -> {
                config.displayDuration = newVal;
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)1.0, (Number)5.0)).step((Number)0.5)).formatValue(value -> class_2561.method_43470((String)(value + "s")))).build();
            Option fadeInTimeOpt = ConfigUtils.getGenericOption("fadeInTime", DescComponent.TICK_EXPLANATION).binding((Object)defaults.fadeInTime, () -> config.fadeInTime, newVal -> {
                config.fadeInTime = newVal;
            }).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).range((Number)0, (Number)60)).formatValue(value -> class_2561.method_43470((String)(value + " ticks")))).build();
            Option fadeOutTimeOpt = ConfigUtils.getGenericOption("fadeOutTime", DescComponent.TICK_EXPLANATION).binding((Object)defaults.fadeOutTime, () -> config.fadeOutTime, newVal -> {
                config.fadeOutTime = newVal;
            }).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).range((Number)0, (Number)60)).formatValue(value -> class_2561.method_43470((String)(value + " ticks")))).build();
            Option scaleOpt = ConfigUtils.getGenericOption("scale").binding((Object)defaults.scale, () -> config.scale, newVal -> {
                config.scale = newVal;
            }).controller(opt -> DoubleFieldControllerBuilder.create((Option)opt).range((Number)0.3, (Number)3.0)).build();
            Option yOffsetOpt = ConfigUtils.getGenericOption("yOffset").binding((Object)defaults.yOffset, () -> config.yOffset, newVal -> {
                config.yOffset = newVal;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).range((Number)-60, (Number)60)).build();
            Option colorOpt = ConfigUtils.getGenericOption("color").binding((Object)defaults.color, () -> config.color, newVal -> {
                config.color = newVal;
            }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(false)).build();
            Option cooldownTimeOpt = ConfigUtils.getGenericOption("cooldownTime").binding((Object)defaults.cooldownTime, () -> config.cooldownTime, newVal -> {
                config.cooldownTime = newVal;
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.0, (Number)5.0)).step((Number)0.5)).formatValue(value -> class_2561.method_43470((String)(value + "s")))).build();
            Option enableModNameOpt = ConfigUtils.getGenericOption("enableModName").binding((Object)defaults.enableModName, () -> config.enableModName, newVal -> {
                config.enableModName = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableUndergroundUpdateOpt = ConfigUtils.getGenericOption("enableUndergroundUpdate").binding((Object)defaults.enableUndergroundUpdate, () -> config.enableUndergroundUpdate, newVal -> {
                config.enableUndergroundUpdate = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableFasterClimbingOpt = ConfigUtils.getGenericOption("enableFasterClimbing").binding((Object)defaults.enableFasterClimbing, () -> config.enableFasterClimbing, newVal -> {
                config.enableFasterClimbing = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableFasterUpwardOpt = ConfigUtils.getGenericOption("enableFasterUpward").binding((Object)defaults.enableFasterUpward, () -> config.enableFasterUpward, newVal -> {
                config.enableFasterUpward = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableFasterDownwardOpt = ConfigUtils.getGenericOption("enableFasterDownward").binding((Object)defaults.enableFasterDownward, () -> config.enableFasterDownward, newVal -> {
                config.enableFasterDownward = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option speedMultiplierOpt = ConfigUtils.getGenericOption("speedMultiplier").binding((Object)defaults.speedMultiplier, () -> config.speedMultiplier, newVal -> {
                config.speedMultiplier = newVal;
            }).controller(opt -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)1.0, (Number)10.0)).step((Number)0.5)).build();
            Option enableBookScrollOpt = ConfigUtils.getGenericOption("enableBookScroll").binding((Object)defaults.enableBookScroll, () -> config.enableBookScroll, newVal -> {
                config.enableBookScroll = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option ctrlSpeedMultiplierOpt = ConfigUtils.getGenericOption("ctrlSpeedMultiplier").binding((Object)defaults.ctrlSpeedMultiplier, () -> config.ctrlSpeedMultiplier, newVal -> {
                config.ctrlSpeedMultiplier = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)1, (Number)10)).step((Number)1)).build();
            Option enablePageTurnSoundOpt = ConfigUtils.getGenericOption("enablePageTurnSound").binding((Object)defaults.enablePageTurnSound, () -> config.enablePageTurnSound, newVal -> {
                config.enablePageTurnSound = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableChatFormatterOpt = ConfigUtils.getGenericOption("enableChatFormatter").binding((Object)defaults.enableChatFormatter, () -> config.enableChatFormatter, newVal -> {
                config.enableChatFormatter = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option posFormatOpt = ConfigUtils.getGenericOption("posFormat").binding((Object)defaults.posFormat, () -> config.posFormat, newVal -> {
                config.posFormat = newVal;
            }).controller(StringControllerBuilder::create).build();
            Option enableBeeInfoOpt = ConfigUtils.getGenericOption("enableBeeInfo", "bee_info").binding((Object)defaults.enableBeeInfo, () -> config.enableBeeInfo, newVal -> {
                config.enableBeeInfo = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableAxolotlBucketFixOpt = ConfigUtils.getGenericOption("enableAxolotlBucketFix", "axolotl_bucket").binding((Object)defaults.enableAxolotlBucketFix, () -> config.enableAxolotlBucketFix, newVal -> {
                config.enableAxolotlBucketFix = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableChatHistoryRetentionOpt = ConfigUtils.getGenericOption("enableChatHistoryRetention").binding((Object)defaults.enableChatHistoryRetention, () -> config.enableChatHistoryRetention, newVal -> {
                config.enableChatHistoryRetention = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableBookSaveConfirmationOpt = ConfigUtils.getGenericOption("enableBookSaveConfirmation").binding((Object)defaults.enableBookSaveConfirmation, () -> config.enableBookSaveConfirmation, newVal -> {
                config.enableBookSaveConfirmation = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            Option enableGlowingEnderEyeOpt = ConfigUtils.getGenericOption("enableGlowingEnderEye").binding((Object)defaults.enableGlowingEnderEye, () -> config.enableGlowingEnderEye, newVal -> {
                config.enableGlowingEnderEye = newVal;
            }).controller(TickBoxControllerBuilder::create).build();
            return builder.title((class_2561)class_2561.method_43471((String)"yacl3.config.better_client:config")).category(ConfigCategory.createBuilder().name(ConfigUtils.getCategoryName(CLIENT_CATEGORY)).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, FADING_NIGHT_VISION_GROUP)).options(List.of(enableFadingNightVisionOpt, fadingOutDurationOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, BETTER_PING_DISPLAY_GROUP)).options(List.of(enableBetterPingDisplayOpt, enableDefaultPingBarsOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, BETTER_CHAT_GROUP)).options(List.of(enableLongerChatHistoryOpt, chatMaxMessagesOpt, enableTimeStampOpt, timeStampColorOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, BIOME_TITLE_GROUP)).options(List.of(enableBiomeTitleOpt, hideInF1Opt, hideInF3Opt, displayDurationOpt, fadeInTimeOpt, fadeOutTimeOpt, scaleOpt, yOffsetOpt, colorOpt, cooldownTimeOpt, enableModNameOpt, enableUndergroundUpdateOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, FASTER_CLIMBING_GROUP)).options(List.of(enableFasterClimbingOpt, enableFasterUpwardOpt, enableFasterDownwardOpt, speedMultiplierOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, BOOK_SCROLL_GROUP)).options(List.of(enableBookScrollOpt, ctrlSpeedMultiplierOpt, enablePageTurnSoundOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, CHAT_FORMATTER_GROUP)).options(List.of(enableChatFormatterOpt, posFormatOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(CLIENT_CATEGORY, OTHER_GROUP)).options(List.of(enableBeeInfoOpt, enableAxolotlBucketFixOpt, enableChatHistoryRetentionOpt, enableBookSaveConfirmationOpt, enableGlowingEnderEyeOpt)).build()).build()).save(BetterClientConfig::save);
        });
    }
}

