/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.api.IHasPlayTime;
import com.euphony.better_client.utils.Utils;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldSelectionList.WorldListEntry.class})
public class WorldListEntryMixin {
    @Unique
    private static final ResourceLocation WORLD_PLAY_TIME_ICON = Utils.prefix("textures/gui/world_play_time.png");
    @Shadow
    @Final
    LevelSummary summary;

    @Redirect(method={"getNarration()Lnet/minecraft/network/chat/Component;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelSummary;isExperimental()Z"))
    private boolean disableExperimentalWarning(LevelSummary instance) {
        if (BetterClient.config.enableNoExperimentalWarning && !BetterClient.config.enableExperimentalDisplay) {
            return false;
        }
        return instance.isExperimental();
    }

    @Redirect(method={"<init>(Lnet/minecraft/client/gui/screens/worldselection/WorldSelectionList;Lnet/minecraft/world/level/storage/LevelSummary;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelSummary;getInfo()Lnet/minecraft/network/chat/Component;"))
    private Component modifyInfo(LevelSummary levelSummary) {
        if (BetterClient.config.enableNoExperimentalWarning && !BetterClient.config.enableExperimentalDisplay) {
            if (levelSummary.info == null) {
                levelSummary.info = this.better_client$createInfo(levelSummary);
            }
            return levelSummary.info;
        }
        return levelSummary.getInfo();
    }

    @Unique
    private Component better_client$createInfo(LevelSummary levelSummary) {
        MutableComponent mutableComponent;
        if (levelSummary.isLocked()) {
            return Component.translatable((String)"selectWorld.locked").withStyle(ChatFormatting.RED);
        }
        if (levelSummary.requiresManualConversion()) {
            return Component.translatable((String)"selectWorld.conversion").withStyle(ChatFormatting.RED);
        }
        if (!levelSummary.isCompatible()) {
            return Component.translatable((String)"selectWorld.incompatible.info", (Object[])new Object[]{levelSummary.getWorldVersionName()}).withStyle(ChatFormatting.RED);
        }
        MutableComponent mutableComponent2 = mutableComponent = levelSummary.isHardcore() ? Component.empty().append((Component)Component.translatable((String)"gameMode.hardcore").withColor(-65536)) : Component.translatable((String)("gameMode." + levelSummary.getGameMode().getName()));
        if (levelSummary.hasCommands()) {
            mutableComponent.append(", ").append((Component)Component.translatable((String)"selectWorld.commands"));
        }
        MutableComponent mutableComponent22 = levelSummary.getWorldVersionName();
        MutableComponent mutableComponent3 = Component.literal((String)", ").append((Component)Component.translatable((String)"selectWorld.version")).append(CommonComponents.SPACE);
        if (levelSummary.shouldBackup()) {
            mutableComponent3.append((Component)mutableComponent22.withStyle(levelSummary.isDowngrade() ? ChatFormatting.RED : ChatFormatting.ITALIC));
        } else {
            mutableComponent3.append((Component)mutableComponent22);
        }
        mutableComponent.append((Component)mutableComponent3);
        return mutableComponent;
    }

    @Inject(at={@At(value="TAIL")}, method={"renderContent(Lnet/minecraft/client/gui/GuiGraphics;IIZF)V"})
    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean pHovering, float pPartialTick, CallbackInfo ci) {
        if (!BetterClient.config.enableWorldPlayTime) {
            return;
        }
        LevelSummary levelSummary = this.summary;
        if (!(levelSummary instanceof IHasPlayTime)) {
            return;
        }
        IHasPlayTime hasPlayTime = (IHasPlayTime)levelSummary;
        int ticks = hasPlayTime.better_client$getPlayTimeTicks();
        if (ticks <= 0) {
            return;
        }
        double hours = (double)ticks / 72000.0;
        String hourText = hours >= 100.0 ? String.valueOf((int)hours) : String.format(Locale.US, "%.1f", hours);
        MutableComponent component = Component.translatable((String)"message.world_play_time", (Object[])new Object[]{Component.literal((String)hourText)});
        Minecraft mc = Minecraft.getInstance();
        int textWidth = mc.font.width((FormattedText)component);
        if (textWidth == 0) {
            return;
        }
        WorldSelectionList.WorldListEntry entry = (WorldSelectionList.WorldListEntry)this;
        int iconSize = 9;
        int spacing = 2;
        int totalWidth = iconSize + spacing + textWidth;
        int renderX = entry.getContentX() + entry.getContentWidth() - totalWidth - 4;
        int renderY = entry.getContentY();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WORLD_PLAY_TIME_ICON, renderX, renderY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, BetterClient.config.worldPlayTimeColor);
        guiGraphics.drawString(mc.font, (Component)component, renderX + iconSize + spacing, renderY + 1, BetterClient.config.worldPlayTimeColor, false);
    }
}

