/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.utils;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;

public class TradingUtils {
    public static boolean isTradableMerchant(Entity entity) {
        if (Objects.isNull(entity) || !(entity instanceof Merchant)) {
            return false;
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            return TradingUtils.isValidVillagerForTrading(villager);
        }
        return true;
    }

    private static boolean isValidVillagerForTrading(Villager villager) {
        Holder profession = villager.getVillagerData().profession();
        if (profession.is(VillagerProfession.NONE) || profession.is(VillagerProfession.NITWIT)) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            ItemStack mainHandItem = player.getMainHandItem();
            return !mainHandItem.is(Items.VILLAGER_SPAWN_EGG) && !mainHandItem.is(Items.NAME_TAG);
        }
        return true;
    }

    public static Entity getCrosshairTradableEntity(Minecraft minecraft, boolean isWindowOpen) {
        if (isWindowOpen) {
            return null;
        }
        Entity crosshairTarget = minecraft.crosshairPickEntity;
        return TradingUtils.isTradableMerchant(crosshairTarget) ? crosshairTarget : null;
    }
}

