/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.mixin;

import com.euphony.better_client.api.IHasPlayTime;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelStorageSource.class})
public class LevelStorageSourceMixin {
    @Inject(at={@At(value="RETURN")}, method={"makeLevelSummary(Lcom/mojang/serialization/Dynamic;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelDirectory;Z)Lnet/minecraft/world/level/storage/LevelSummary;"})
    public void onMakeLevelSummary(Dynamic<?> dynamic, LevelStorageSource.LevelDirectory levelDirectory, boolean locked, CallbackInfoReturnable<LevelSummary> cir) {
        LevelSummary summary = (LevelSummary)cir.getReturnValue();
        if (!(summary instanceof IHasPlayTime)) {
            return;
        }
        IHasPlayTime playTimeSummary = (IHasPlayTime)summary;
        Path statsDir = levelDirectory.resourcePath(LevelResource.PLAYER_STATS_DIR);
        File dir = statsDir.toFile();
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".json"));
        if (files == null || files.length == 0) {
            return;
        }
        int totalTicks = 0;
        for (File file : files) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject custom = root.getAsJsonObject("stats").getAsJsonObject("minecraft:custom");
                if (!custom.has("minecraft:play_time")) continue;
                totalTicks += custom.get("minecraft:play_time").getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (totalTicks > 0) {
            playTimeSummary.better_client$setPlayTimeTicks(totalTicks);
        }
    }
}

