/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.utils;

import com.euphony.better_client.utils.Utils;
import com.euphony.better_client.utils.enums.DescComponent;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.Resource;

public class ConfigUtils {
    public static final int IMG_WIDTH = 1920;
    public static final int IMG_HEIGHT = 991;
    private static final Map<ResourceLocation, int[]> IMAGE_DIMENSIONS_CACHE = new HashMap<ResourceLocation, int[]>();
    public static final OptionFlag RESOURCE_RELOAD = client -> {
        IntegratedServer server;
        if (client.hasSingleplayerServer() && (server = client.getSingleplayerServer()) != null) {
            PackRepository packrepository = server.getPackRepository();
            Collection collection = packrepository.getSelectedIds();
            server.reloadResources(collection);
        }
    };

    public static ListOption.Builder<String> getListGroupOption(String name) {
        return ListOption.createBuilder().name(ConfigUtils.getOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, null)}).build());
    }

    public static ButtonOption.Builder getButtonOption(String name) {
        return ButtonOption.createBuilder().name(ConfigUtils.getButtonOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, null)}).build());
    }

    public static Option<Boolean> buildBooleanOption(String name, boolean defaultValue, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return ConfigUtils.getBooleanOption(name).binding((Object)defaultValue, getter, setter).controller(TickBoxControllerBuilder::create).build();
    }

    public static Option.Builder<Boolean> getBooleanOption(String name) {
        return Option.createBuilder().name(ConfigUtils.getOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, null)}).build());
    }

    public static <T> Option.Builder<T> getGenericOption(String name) {
        return ConfigUtils.getGenericOption(name, (DescComponent)null);
    }

    public static <T> Option.Builder<T> getGenericOption(String name, DescComponent descComponent) {
        return Option.createBuilder().name(ConfigUtils.getOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, descComponent)}).build());
    }

    public static <T> Option.Builder<T> getGenericOption(String name, String image) {
        return ConfigUtils.getGenericOption(name, image, null);
    }

    public static <T> Option.Builder<T> getGenericOption(String name, String image, DescComponent descComponent) {
        int[] dimensions = ConfigUtils.getImageDimensions(Utils.prefix(String.format("config/%s.png", image)));
        return Option.createBuilder().name(ConfigUtils.getOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, descComponent)}).image(ConfigUtils.getImage(image), dimensions[0], dimensions[1]).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getImageDimensions(ResourceLocation location) {
        if (IMAGE_DIMENSIONS_CACHE.containsKey(location)) {
            return IMAGE_DIMENSIONS_CACHE.get(location);
        }
        Minecraft mc = Minecraft.getInstance();
        Optional resource = mc.getResourceManager().getResource(location);
        if (!resource.isPresent()) return new int[]{1920, 991};
        try (InputStream inputStream = ((Resource)resource.get()).open();){
            BufferedImage image = ImageIO.read(inputStream);
            if (image == null) return new int[]{1920, 991};
            int[] dimensions = new int[]{image.getWidth(), image.getHeight()};
            IMAGE_DIMENSIONS_CACHE.put(location, dimensions);
            int[] nArray = dimensions;
            return nArray;
        }
        catch (IOException e) {
            return new int[]{1920, 991};
        }
    }

    public static Component getCategoryName(String category) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.category.%s", "better_client", category));
    }

    public static Component getGroupName(String category, String group) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.category.%s.group.%s", "better_client", category, group));
    }

    private static Component getButtonOptionName(String option) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.%s.button", "better_client", option));
    }

    private static Component getOptionName(String option) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.%s", "better_client", option));
    }

    private static Component getDesc(String option, DescComponent descComponent) {
        MutableComponent component = Component.translatable((String)String.format("yacl3.config.%s:config.%s.desc", "better_client", option));
        if (descComponent != null) {
            component.append((Component)Component.literal((String)"\n\n").append(descComponent.getText()));
        }
        return component;
    }

    private static ResourceLocation getImage(String name) {
        return Utils.prefix(String.format("config/%s.png", name));
    }
}

