/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.client.events;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.utils.BiomeUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class BiomeTitleEvent {
    private static final int MAX_ALPHA = 255;
    private static final int TICKS_PER_SECOND = 20;
    private static class_1959 previousBiome;
    private static class_5321<class_1959> displayBiome;
    private static int displayTime;
    private static int alpha;
    private static int cooldownTime;
    private static int fadeTimer;
    private static boolean complete;
    private static boolean fadingIn;
    public static final Map<class_5321<class_1959>, class_2561> NAME_CACHE;

    private BiomeTitleEvent() {
    }

    public static void clientPre(class_310 minecraft) {
        if (!complete) {
            return;
        }
        if (fadingIn) {
            BiomeTitleEvent.handleFadeIn();
        } else {
            BiomeTitleEvent.handleDisplay();
        }
    }

    public static void renderBiomeInfo(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!BiomeTitleEvent.shouldRender()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_1297 player = mc.method_1560();
        if (player == null) {
            return;
        }
        class_2338 pos = player.method_23312();
        if (mc.field_1687 == null || !mc.field_1687.method_8477(pos)) {
            return;
        }
        class_6880 biomeHolder = mc.field_1687.method_23753(pos);
        if (!biomeHolder.method_40227()) {
            return;
        }
        class_1959 currentBiome = (class_1959)biomeHolder.comp_349();
        if (BiomeTitleEvent.shouldUpdateBiome(currentBiome, pos, mc)) {
            BiomeTitleEvent.updateBiomeDisplay((class_6880<class_1959>)biomeHolder);
        }
        if (alpha > 0) {
            BiomeTitleEvent.renderBiomeTitle(guiGraphics, mc);
        }
    }

    public static void clientLevelLoad(class_638 clientLevel) {
        complete = true;
    }

    private static void handleFadeIn() {
        if (fadeTimer < BetterClient.config.fadeInTime) {
            alpha = BiomeTitleEvent.calculateAlpha(++fadeTimer, BetterClient.config.fadeInTime);
        } else {
            BiomeTitleEvent.completeFadeIn();
        }
    }

    private static void handleDisplay() {
        if (displayTime > 0) {
            --displayTime;
        } else if (fadeTimer > 0) {
            alpha = BiomeTitleEvent.calculateAlpha(--fadeTimer, BetterClient.config.fadeOutTime);
        } else if (cooldownTime > 0) {
            --cooldownTime;
        }
    }

    private static void completeFadeIn() {
        fadeTimer = BetterClient.config.fadeOutTime;
        fadingIn = false;
        displayTime = (int)(BetterClient.config.displayDuration * 20.0);
        alpha = 255;
    }

    private static int calculateAlpha(int timer, int maxTime) {
        return (int)(255.0f / (float)maxTime * (float)timer);
    }

    private static boolean shouldRender() {
        return complete && BetterClient.config.enableBiomeTitle;
    }

    private static boolean shouldUpdateBiome(class_1959 currentBiome, class_2338 pos, class_310 mc) {
        if (previousBiome == currentBiome || cooldownTime > 0) {
            return false;
        }
        boolean isUnderground = mc.field_1687.method_8597().comp_642() && !mc.field_1687.method_8311(pos);
        return BetterClient.config.enableUndergroundUpdate || !isUnderground;
    }

    private static void updateBiomeDisplay(class_6880<class_1959> biomeHolder) {
        previousBiome = (class_1959)biomeHolder.comp_349();
        biomeHolder.method_40230().ifPresent(BiomeTitleEvent::initializeBiomeDisplay);
    }

    private static void initializeBiomeDisplay(class_5321<class_1959> key) {
        cooldownTime = (int)(BetterClient.config.cooldownTime * 20.0);
        displayBiome = key;
        displayTime = 0;
        alpha = 0;
        fadeTimer = 0;
        fadingIn = true;
    }

    private static void renderBiomeTitle(class_332 guiGraphics, class_310 mc) {
        if (BiomeTitleEvent.shouldHideDisplay(mc)) {
            return;
        }
        class_327 font = mc.field_1772;
        float scale = (float)BetterClient.config.scale;
        Matrix3x2fStack pose = guiGraphics.method_51448();
        pose.pushMatrix();
        pose.translate((float)((double)guiGraphics.method_51421() / 2.0), (float)((double)guiGraphics.method_51443() / 2.0));
        pose.scale(scale, scale);
        class_2561 biomeName = BiomeTitleEvent.getBiomeName(displayBiome);
        int textWidth = font.method_27525((class_5348)biomeName);
        int y = -font.method_1713(biomeName.getString(), 999) / 2 + BetterClient.config.yOffset;
        guiGraphics.method_51439(font, biomeName, -textWidth / 2, y, 0xFFFFFF | alpha << 24, true);
        pose.popMatrix();
    }

    private static boolean shouldHideDisplay(class_310 mc) {
        return mc.field_1690.field_1842 && BetterClient.config.hideInF1 || mc.method_53526().method_53536() && BetterClient.config.hideInF3;
    }

    private static class_2561 getBiomeName(class_5321<class_1959> key) {
        return NAME_CACHE.computeIfAbsent(key, k -> BiomeUtils.createBiomeDisplayComponent((class_5321<class_1959>)k, BetterClient.config.enableModName));
    }

    static {
        displayTime = 0;
        alpha = 0;
        cooldownTime = 0;
        fadeTimer = 0;
        complete = false;
        fadingIn = false;
        NAME_CACHE = new HashMap<class_5321<class_1959>, class_2561>();
    }
}

