/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_client.config;

import com.euphony.better_client.BetterClient;
import com.euphony.better_client.config.YACLConfig;
import com.euphony.better_client.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_437;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path BASE_PATH = Platform.getConfigFolder().resolve("better_client");
    private static final Path PATH = BASE_PATH.resolve("client.json");
    public static Config DEFAULTS = new Config();
    public boolean enableFadingNightVision = true;
    public double fadingOutDuration = 3.0;
    public boolean enableBetterPingDisplay = true;
    public boolean enableDefaultPingBars = false;
    public boolean enableLongerChatHistory = true;
    public int chatMaxMessages = 4096;
    public boolean enableTimeStamp = true;
    public int timeStampColor = 15615743;
    public boolean enableFasterClimbing = false;
    public boolean enableFasterUpward = true;
    public boolean enableFasterDownward = true;
    public double speedMultiplier = 2.0;
    public boolean enableBiomeTitle = true;
    public boolean hideInF3 = true;
    public boolean hideInF1 = true;
    public double displayDuration = 1.5;
    public int fadeInTime = 20;
    public int fadeOutTime = 20;
    public double scale = 2.1;
    public int biomeTitleYOffset = -10;
    public int biomeTitleColor = 0xFFFFFF;
    public double cooldownTime = 1.5;
    public boolean enableModName = false;
    public boolean enableUndergroundUpdate = false;
    public boolean enableBookScroll = true;
    public int ctrlSpeedMultiplier = 5;
    public boolean enablePageTurnSound = true;
    public boolean enableMusicPause = true;
    public boolean pauseUiSound = false;
    public boolean enableFastTrading = true;
    public boolean enableAltKey = true;
    public boolean enableNoExperimentalWarning = true;
    public boolean enableExperimentalDisplay = true;
    public boolean enableBundleUp = true;
    public boolean enableDurabilityTooltip = true;
    public boolean showDurabilityWhenNotDamaged = true;
    public boolean showDurabilityHint = true;
    public boolean enableTradingHud = true;
    public int tradingHudXOffset = 0;
    public int tradingHudYOffset = 0;
    public boolean renderRealCostDirectly = true;
    public boolean enableAxolotlBucketFix = true;
    public boolean enableChatHistoryRetention = true;
    public boolean enableBookSaveConfirmation = true;
    public boolean enableDisplayRemainingSales = true;
    public boolean enableGlowingEnderEye = true;
    public boolean enableWorldIconUpdate = false;
    public boolean enableFullBrightnessToggle = true;
    public boolean enableCompassTooltip = true;
    public boolean enableNormalCompassTooltip = true;
    public boolean enableLodestoneTooltip = true;
    public boolean enableRecoveryCompassTooltip = true;
    public boolean enableSuspiciousStewTooltip = true;
    public boolean enableChatFormatter = true;
    public String posFormat = "{x}, {y}, {z}";
    public boolean enableWorldPlayTime = true;
    public int worldPlayTimeColor = 0x808080;
    public boolean enableTrialSpawnerTimer = true;
    public boolean timerSeenThroughWalls = false;
    public boolean highSensitivityMode = true;
    public long trialSpawnerCooldown = 1800L;
    public boolean enableDynamicTimerColor = true;
    public int timerColor = -30465;
    public boolean enableDropShadow = true;

    public static Config create() {
        if (!Platform.isModLoaded((String)"yet_another_config_lib_v3")) {
            return DEFAULTS;
        }
        boolean accessibleInGame = false;
        if (Platform.isFabric()) {
            accessibleInGame = Platform.isModLoaded((String)"modmenu") || Platform.isModLoaded((String)"catalogue") && Platform.isModLoaded((String)"menulogue");
        } else if (Platform.isNeoForge()) {
            accessibleInGame = true;
        }
        BetterClient.config = accessibleInGame ? new YACLConfig() : DEFAULTS;
        Config.load();
        return BetterClient.config;
    }

    public static void load() {
        if (Files.notExists(BASE_PATH, new LinkOption[0])) {
            try {
                Files.createDirectories(BASE_PATH, new FileAttribute[0]);
            }
            catch (Exception e) {
                BetterClient.LOGGER.error("Couldn't create config directory: ", (Throwable)e);
                return;
            }
        }
        if (Files.notExists(PATH, new LinkOption[0])) {
            if (Utils.isAnyModLoaded("durabilitytooltip", "rmes-durability-tooltips")) {
                BetterClient.config.enableDurabilityTooltip = false;
            }
            if (Utils.isAnyModLoaded("hideexperimentalwarning")) {
                BetterClient.config.enableNoExperimentalWarning = false;
            }
            Config.save();
        } else {
            try {
                BetterClient.config = (Config)GSON.fromJson(Files.readString(PATH), BetterClient.config.getClass());
            }
            catch (Exception e) {
                BetterClient.LOGGER.error("Couldn't load config file: ", (Throwable)e);
            }
        }
    }

    public static void save() {
        try {
            Files.write(PATH, Collections.singleton(GSON.toJson((Object)BetterClient.config)), new OpenOption[0]);
        }
        catch (Exception e) {
            BetterClient.LOGGER.error("Couldn't save config file: ", (Throwable)e);
        }
    }

    public class_437 makeScreen(class_437 parent) {
        class_310 mc = class_310.method_1551();
        String link = "https://modrinth.com/mod/yacl";
        return new class_410(clicked -> {
            if (clicked) {
                class_407.method_49623((class_437)parent, (String)link);
            } else {
                mc.method_1507(parent);
            }
        }, (class_2561)class_2561.method_43471((String)"text.better_client.help.missing"), (class_2561)class_2561.method_43471((String)"text.better_client.desc.help.missing"), (class_2561)class_2561.method_43471((String)"gui.continue"), (class_2561)class_2561.method_43471((String)"gui.back"));
    }
}

